/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.rulers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramGuide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramRuler
implements Serializable {
    public static final String PROPERTY_CHILDREN = "children changed";
    public static final String PROPERTY_UNIT = "units changed";
    static final long serialVersionUID = 1L;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private int unit;
    private boolean horizontal;
    private List<DiagramGuide> guides = new ArrayList<DiagramGuide>();

    public DiagramRuler(boolean isHorizontal) {
        this(isHorizontal, 2);
    }

    public DiagramRuler(boolean isHorizontal, int unit) {
        this.horizontal = isHorizontal;
        this.setUnit(unit);
    }

    public void addGuide(DiagramGuide guide) {
        if (!this.guides.contains(guide)) {
            guide.setHorizontal(!this.isHorizontal());
            this.guides.add(guide);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public List<DiagramGuide> getGuides() {
        return this.guides;
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removeGuide(DiagramGuide guide) {
        if (this.guides.remove(guide)) {
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setHidden(boolean isHidden) {
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            int oldUnit = this.unit;
            this.unit = newUnit;
            this.listeners.firePropertyChange(PROPERTY_UNIT, oldUnit, newUnit);
        }
    }
}

