/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.resource.spi;

import java.io.Serializable;

import javax.resource.ResourceException;

/**
 * The ConnectionManager interface provides the hook which allows a resource
 * adapter to pass a connection to the Application Server. The Application
 * Server implements this interface in order to control QoS services to the
 * resource adapter for connection pools.
 */

public interface ConnectionManager extends Serializable
{
   /**
	 * Gets called by the resource adapter's connection factory. The resource adapter
    * uses this method to pass its managed connection factory to the connection manager.
    * 
    * @param mcf the managed connection factory
    * @param cxRequestInfo the connection request info
    * @return the connection handle
    * @throws ResourceException for an generic error
    * @throws ApplicationServerInternalException for problems in the application server
    * @throws SecurityException for security problems
    * @throws ResourceAllocationException for problems allocating resources
    * @throws ResourceAdapterInternalException for errors from the resource adapter 
	 */
   public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo)
         throws ResourceException;
}