/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package javax.jms;

/**
 * <P> This exception must be thrown when a 
 *     call to <CODE>Session.commit</CODE> results in a rollback of the current 
 *     transaction.
 **/

public class TransactionRolledBackException extends JMSException {

  /** Constructs a <CODE>TransactionRolledBackException</CODE> with the 
   *  specified reason and error code.
   *
   *  @param  reason        a description of the exception
   *  @param  errorCode     a string specifying the vendor-specific
   *                        error code
   *                        
   **/
  public 
  TransactionRolledBackException(String reason, String errorCode) {
    super(reason, errorCode);
  }

  /** Constructs a <CODE>TransactionRolledBackException</CODE> with the 
   *  specified reason. The error code defaults to null.
   *
   *  @param  reason        a description of the exception
   **/
  public 
  TransactionRolledBackException(String reason) {
    super(reason);
  }

}
