/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.xpl;

import java.util.HashSet;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.IVariableManager;

public class StringSubstitutionEngineClone {
    private static final String VARIABLE_START = "${";
    private static final char VARIABLE_END = '}';
    private static final int SCAN_FOR_START = 0;
    private static final int SCAN_FOR_END = 1;
    private StringBuffer fResult;

    public String performStringSubstitution(String expression, boolean reportUndefinedVariables, IVariableManager manager) throws CoreException {
        this.substitute(expression, reportUndefinedVariables, manager);
        return this.fResult.toString();
    }

    public void validateStringVariables(String expression, IVariableManager manager) throws CoreException {
        this.performStringSubstitution(expression, true, manager);
    }

    private HashSet substitute(String expression, boolean reportUndefinedVariables, IVariableManager manager) throws CoreException {
        this.fResult = new StringBuffer(expression.length());
        Stack<VariableReference> fStack = new Stack<VariableReference>();
        HashSet<String> resolvedVariables = new HashSet<String>();
        int pos = 0;
        int state = 0;
        while (pos < expression.length()) {
            switch (state) {
                case 0: {
                    int start = expression.indexOf(VARIABLE_START, pos);
                    if (start >= 0) {
                        int length = start - pos;
                        if (length > 0) {
                            this.fResult.append(expression.substring(pos, start));
                        }
                        pos = start + 2;
                        state = 1;
                        fStack.push(new VariableReference());
                        break;
                    }
                    this.fResult.append(expression.substring(pos));
                    pos = expression.length();
                    break;
                }
                case 1: {
                    VariableReference tos;
                    int start = expression.indexOf(VARIABLE_START, pos);
                    int end = expression.indexOf(125, pos);
                    if (end < 0) {
                        tos = (VariableReference)fStack.peek();
                        tos.append(expression.substring(pos));
                        pos = expression.length();
                        break;
                    }
                    if (start >= 0 && start < end) {
                        int length = start - pos;
                        if (length > 0) {
                            VariableReference tos2 = (VariableReference)fStack.peek();
                            tos2.append(expression.substring(pos, start));
                        }
                        pos = start + 2;
                        fStack.push(new VariableReference());
                        break;
                    }
                    tos = (VariableReference)fStack.pop();
                    String substring = expression.substring(pos, end);
                    tos.append(substring);
                    resolvedVariables.add(substring);
                    pos = end + 1;
                    String value = this.resolve(tos, reportUndefinedVariables, manager);
                    if (value == null) {
                        value = "";
                    }
                    if (fStack.isEmpty()) {
                        this.fResult.append(value);
                        state = 0;
                        break;
                    }
                    tos = (VariableReference)fStack.peek();
                    tos.append(value);
                }
            }
        }
        while (!fStack.isEmpty()) {
            VariableReference tos = (VariableReference)fStack.pop();
            if (fStack.isEmpty()) {
                this.fResult.append(VARIABLE_START);
                this.fResult.append(tos.getText());
                continue;
            }
            VariableReference var = (VariableReference)fStack.peek();
            var.append(VARIABLE_START);
            var.append(tos.getText());
        }
        return resolvedVariables;
    }

    private String resolve(VariableReference var, boolean reportUndefinedVariables, IVariableManager manager) throws CoreException {
        String text = var.getText();
        String name = null;
        name = text;
        if (!manager.containsVariable(name)) {
            if (reportUndefinedVariables) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.VariableUndefined, name)));
            }
            return this.getOriginalVarText(var);
        }
        String ret = manager.getVariableValue(name);
        if (ret == null) {
            return this.getOriginalVarText(var);
        }
        return ret;
    }

    private String getOriginalVarText(VariableReference var) {
        StringBuffer res = new StringBuffer(var.getText());
        res.insert(0, VARIABLE_START);
        res.append('}');
        return res.toString();
    }

    class VariableReference {
        private StringBuffer fText = new StringBuffer();

        public void append(String text) {
            this.fText.append(text);
        }

        public String getText() {
            return this.fText.toString();
        }
    }
}

