/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleRulerVisibilityAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramContentOutlinePage;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ActionMenu;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.AutoLayoutAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ConnectionRouterFanAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ConnectionRouterManhattanAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ExportImageAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.LexicalSortingAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.OpenMappingAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.OpenSourceAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.PrintDiagramViewerAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.RefreshAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ShapeCollapseAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ShapeExpandAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ShapeHideAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ShapeShowAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ToggleAssociationAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ToggleClassMappingAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ToggleConnectionsAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ToggleForeignKeyConstraintAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.TogglePropertyMappingAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ToggleShapeExpandStateAction;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.ToggleShapeVisibleStateAction;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.DiagramEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.GEFRootEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmEditPartFactory;
import org.jboss.tools.hibernate.ui.diagram.editors.popup.PopupMenuProvider;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramRuler;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramRulerProvider;
import org.jboss.tools.hibernate.ui.view.DiagramEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramViewer
extends GraphicalEditor {
    private GEFRootEditPart gefRootEditPart = new GEFRootEditPart();
    private KeyHandler sharedKeyHandler;
    private RulerComposite rulerComp;
    private DiagramContentOutlinePage outlinePage;

    public DiagramViewer() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveProperties();
        this.getOrmDiagram().saveInXmlFile();
        this.getOrmDiagram().setDirty(false);
    }

    public void doSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        saveAsDialog.setOriginalName(this.getStoreFileName());
        saveAsDialog.open();
        IPath pathSave = saveAsDialog.getResult();
        if (pathSave == null) {
            return;
        }
        this.saveProperties();
        IPath pathTmp = pathSave;
        String ext = pathSave.getFileExtension();
        if (ext == null) {
            pathTmp = pathTmp.addFileExtension("hibernate");
        }
        this.getOrmDiagram().saveInWorkspaceFile(pathTmp, true);
        this.getOrmDiagram().setDirty(false);
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new OrmEditPartFactory());
        viewer.setKeyHandler(new GraphicalViewerKeyHandler(viewer).setParent(this.getCommonKeyHandler()));
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        this.gefRootEditPart.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(this.gefRootEditPart.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(this.gefRootEditPart.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        viewer.setRootEditPart((RootEditPart)this.gefRootEditPart);
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
        viewer.setContents((Object)this.getOrmDiagram());
        PopupMenuProvider provider = new PopupMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("FlowDiagramContextmenu", (MenuManager)provider, (ISelectionProvider)viewer);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        DiagramRuler ruler = this.getOrmDiagram().getRuler(8);
        DiagramRulerProvider rulerProvider = null;
        if (ruler != null) {
            rulerProvider = new DiagramRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("vertical ruler", (Object)rulerProvider);
        ruler = this.getOrmDiagram().getRuler(1);
        rulerProvider = null;
        if (ruler != null) {
            rulerProvider = new DiagramRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("horizontal ruler", (Object)rulerProvider);
        this.getGraphicalViewer().setProperty("ruler$visibility", (Object)new Boolean(this.getOrmDiagram().getRulerVisibility()));
        this.loadProperties();
        this.updateConnectionRouterActions();
    }

    public GraphicalViewer getEditPartViewer() {
        return this.getGraphicalViewer();
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new RefreshAction(this);
        registry.registerAction((IAction)action);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)action);
        action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new SelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new DeleteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SaveAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getPropertyActions().add(action.getId());
        registry.registerAction((IAction)new PrintDiagramViewerAction((IWorkbenchPart)this));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), this.getActionRegistry().getAction((Object)ActionFactory.PRINT.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getActionRegistry().getAction((Object)ActionFactory.SELECT_ALL.getId()));
        action = new OpenMappingAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new OpenSourceAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ExportImageAction(this);
        registry.registerAction((IAction)action);
        action = new AutoLayoutAction(this);
        registry.registerAction((IAction)action);
        ToggleConnectionsAction actionToggleConnections = new ToggleConnectionsAction(this);
        registry.registerAction((IAction)actionToggleConnections);
        action = new ToggleAssociationAction(this);
        registry.registerAction((IAction)action);
        action = new ToggleClassMappingAction(this);
        registry.registerAction((IAction)action);
        action = new ToggleForeignKeyConstraintAction(this);
        registry.registerAction((IAction)action);
        action = new TogglePropertyMappingAction(this);
        registry.registerAction((IAction)action);
        action = new ConnectionRouterFanAction(this);
        registry.registerAction((IAction)action);
        this.getPropertyActions().add(action.getId());
        action = new ConnectionRouterManhattanAction(this);
        registry.registerAction((IAction)action);
        this.getPropertyActions().add(action.getId());
        ToggleShapeExpandStateAction actionToggleShapeExpandState = new ToggleShapeExpandStateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)actionToggleShapeExpandState);
        this.getSelectionActions().add(actionToggleShapeExpandState.getId());
        action = new ShapeExpandAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ShapeCollapseAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        ToggleShapeVisibleStateAction actionToggleShapeVisibleState = new ToggleShapeVisibleStateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)actionToggleShapeVisibleState);
        this.getSelectionActions().add(actionToggleShapeVisibleState.getId());
        action = new ShapeHideAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ShapeShowAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ZoomInAction(this.gefRootEditPart.getZoomManager());
        registry.registerAction((IAction)action);
        action = new ZoomOutAction(this.gefRootEditPart.getZoomManager());
        registry.registerAction((IAction)action);
        action = new LexicalSortingAction(this, null);
        registry.registerAction((IAction)action);
        Action[] act = new Action[]{(Action)registry.getAction((Object)"togglePropertyMappingId"), (Action)registry.getAction((Object)"toggleClassMappingId"), (Action)registry.getAction((Object)"toggleAssociationId"), (Action)registry.getAction((Object)"toggleForeignKeyConstraintId")};
        actionToggleConnections.setMenuCreator(new ActionMenu(act));
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                return new SimpleFactory((Class)template);
            }
        };
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void refreshDirty() {
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.getOrmDiagram().isDirty();
    }

    protected void setInput(IEditorInput input) {
        DiagramEditorInput diagramInput = null;
        if (input instanceof FileEditorInput) {
            diagramInput = new DiagramEditorInput((FileEditorInput)input);
        } else if (input instanceof DiagramEditorInput) {
            diagramInput = (DiagramEditorInput)input;
        }
        this.setPartName(diagramInput.getName());
        super.setInput((IEditorInput)diagramInput);
        this.loadProperties();
    }

    public DiagramEditorInput getDiagramInput() {
        DiagramEditorInput diagramInput = (DiagramEditorInput)this.getEditorInput();
        return diagramInput;
    }

    public String getDiagramName() {
        DiagramEditorInput diagramInput = this.getDiagramInput();
        if (diagramInput != null) {
            return diagramInput.getName();
        }
        return "";
    }

    public String getStoreFileName() {
        DiagramEditorInput diagramInput = this.getDiagramInput();
        if (diagramInput != null) {
            return diagramInput.getStoreFileName();
        }
        return "";
    }

    public void refresh() {
        this.getOrmDiagram().refresh();
        this.setPartName(this.getDiagramInput().getName());
    }

    protected DiagramContentOutlinePage getDiagramContentOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new DiagramContentOutlinePage((EditPartViewer)new TreeViewer(), this.getActionRegistry());
        }
        return this.outlinePage;
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            DiagramContentOutlinePage outline = this.getDiagramContentOutlinePage();
            outline.setGraphicalViewer(this.getGraphicalViewer());
            outline.setSelectionSynchronizer(this.getSelectionSynchronizer());
            outline.setOrmDiagram(this.getOrmDiagram());
            outline.setEditor(this);
            RefreshAction refreshAction = (RefreshAction)this.getActionRegistry().getAction((Object)ActionFactory.REFRESH.getId());
            refreshAction.setOutlinePage(outline);
            LexicalSortingAction lexicalSortAction = (LexicalSortingAction)this.getActionRegistry().getAction((Object)"toggleLexicalSortingId");
            lexicalSortAction.setOutlinePage(outline);
            return outline;
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    public Set<Shape> getSelectedElements() {
        HashSet<Shape> ret = new HashSet<Shape>();
        List selectedEditParts = this.getGraphicalViewer().getSelectedEditParts();
        for (Object elem : selectedEditParts) {
            if (!(elem instanceof OrmEditPart)) continue;
            Shape shape = (Shape)((OrmEditPart)elem).getModel();
            ret.add(shape);
        }
        return ret;
    }

    public OrmDiagram getOrmDiagram() {
        return this.getDiagramInput().getOrmDiagram();
    }

    public DefaultEditDomain getDefaultEditDomain() {
        return this.getEditDomain();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.loadProperties();
        ToggleRulerVisibilityAction showRulers = new ToggleRulerVisibilityAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showRulers);
        ToggleSnapToGeometryAction snapAction = new ToggleSnapToGeometryAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)snapAction);
        ToggleGridAction showGrid = new ToggleGridAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showGrid);
    }

    protected boolean loadProperties() {
        if (this.getOrmDiagram() == null || this.getGraphicalViewer() == null) {
            return false;
        }
        DiagramRuler ruler = this.getOrmDiagram().getRuler(8);
        DiagramRulerProvider provider = null;
        if (ruler != null) {
            provider = new DiagramRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("vertical ruler", (Object)provider);
        ruler = this.getOrmDiagram().getRuler(1);
        provider = null;
        if (ruler != null) {
            provider = new DiagramRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("horizontal ruler", (Object)provider);
        this.getGraphicalViewer().setProperty("ruler$visibility", (Object)new Boolean(this.getOrmDiagram().getRulerVisibility()));
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)new Boolean(this.getOrmDiagram().isSnapToGeometryEnabled()));
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(this.getOrmDiagram().isGridEnabled()));
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(this.getOrmDiagram().isGridEnabled()));
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (manager != null) {
            manager.setZoom(this.getOrmDiagram().getZoom());
        }
        return true;
    }

    protected boolean saveProperties() {
        if (this.getOrmDiagram() == null || this.getGraphicalViewer() == null) {
            return false;
        }
        this.getOrmDiagram().setRulerVisibility((Boolean)this.getGraphicalViewer().getProperty("ruler$visibility"));
        this.getOrmDiagram().setGridEnabled((Boolean)this.getGraphicalViewer().getProperty("SnapToGrid.isEnabled"));
        this.getOrmDiagram().setSnapToGeometry((Boolean)this.getGraphicalViewer().getProperty("SnapToGeometry.isEnabled"));
        this.getOrmDiagram().setZoom(this.getZoom());
        return true;
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new RulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    public double getZoom() {
        double zoom = 1.0;
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (manager != null) {
            zoom = manager.getZoom();
        }
        return zoom;
    }

    public double getFitHeightZoomValue() {
        double res = 1.0;
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        Method m = null;
        try {
            m = manager.getClass().getDeclaredMethod("getFitHeightZoomLevel", new Class[0]);
            m.setAccessible(true);
            res = (Double)m.invoke((Object)manager, new Object[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return res;
    }

    public double getFitPageZoomValue() {
        double res = 1.0;
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        Method m = null;
        try {
            m = manager.getClass().getDeclaredMethod("getFitPageZoomLevel", new Class[0]);
            m.setAccessible(true);
            res = (Double)m.invoke((Object)manager, new Object[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return res;
    }

    public double getFitWidthZoomValue() {
        double res = 1.0;
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        Method m = null;
        try {
            m = manager.getClass().getDeclaredMethod("getFitWidthZoomLevel", new Class[0]);
            m.setAccessible(true);
            res = (Double)m.invoke((Object)manager, new Object[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return res;
    }

    public boolean getConnectionsVisibilityAssociation() {
        return this.getOrmDiagram().getConnectionsVisibilityAssociation();
    }

    public void setConnectionsVisibilityAssociation(boolean connectionsVisibilityAssociation) {
        this.getOrmDiagram().setConnectionsVisibilityAssociation(connectionsVisibilityAssociation);
        ActionRegistry registry = this.getActionRegistry();
        IAction action = registry.getAction((Object)"toggleAssociationId");
        action.setChecked(connectionsVisibilityAssociation);
    }

    public boolean getConnectionsVisibilityClassMapping() {
        return this.getOrmDiagram().getConnectionsVisibilityClassMapping();
    }

    public void setConnectionsVisibilityClassMapping(boolean connectionsVisibilityClassMapping) {
        this.getOrmDiagram().setConnectionsVisibilityClassMapping(connectionsVisibilityClassMapping);
        ActionRegistry registry = this.getActionRegistry();
        IAction action = registry.getAction((Object)"toggleClassMappingId");
        action.setChecked(connectionsVisibilityClassMapping);
    }

    public boolean getConnectionsVisibilityForeignKeyConstraint() {
        return this.getOrmDiagram().getConnectionsVisibilityForeignKeyConstraint();
    }

    public void setConnectionsVisibilityForeignKeyConstraint(boolean connectionsVisibilityForeignKeyConstraint) {
        this.getOrmDiagram().setConnectionsVisibilityForeignKeyConstraint(connectionsVisibilityForeignKeyConstraint);
        ActionRegistry registry = this.getActionRegistry();
        IAction action = registry.getAction((Object)"toggleForeignKeyConstraintId");
        action.setChecked(connectionsVisibilityForeignKeyConstraint);
    }

    public boolean getConnectionsVisibilityPropertyMapping() {
        return this.getOrmDiagram().getConnectionsVisibilityPropertyMapping();
    }

    public void setConnectionsVisibilityPropertyMapping(boolean connectionsVisibilityPropertyMapping) {
        this.getOrmDiagram().setConnectionsVisibilityPropertyMapping(connectionsVisibilityPropertyMapping);
        ActionRegistry registry = this.getActionRegistry();
        IAction action = registry.getAction((Object)"togglePropertyMappingId");
        action.setChecked(connectionsVisibilityPropertyMapping);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\r', (int)Action.findKeyCode((String)"RETURN"), (int)0), this.getActionRegistry().getAction((Object)"toggleShapeExpandStateId"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\r', (int)0x1000050, (int)0), this.getActionRegistry().getAction((Object)"toggleShapeExpandStateId"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'+', (int)16777259, (int)0), this.getActionRegistry().getAction((Object)"toggleShapeVisibleStateId"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'=', (int)61, (int)0), this.getActionRegistry().getAction((Object)"toggleShapeVisibleStateId"));
            this.sharedKeyHandler.put(KeyStroke.getReleased((char)' ', (int)Action.findKeyCode((String)"SPACE"), (int)0), this.getActionRegistry().getAction((Object)"toggleLexicalSortingId"));
        }
        return this.sharedKeyHandler;
    }

    public IAction getLexicalSortingAction() {
        return this.getActionRegistry().getAction((Object)"toggleLexicalSortingId");
    }

    public GEFRootEditPart getRootEditPart() {
        return this.gefRootEditPart;
    }

    public DiagramEditPart getDiagramEditPart() {
        Object obj;
        if (!this.gefRootEditPart.getChildren().isEmpty() && (obj = this.gefRootEditPart.getChildren().get(0)) instanceof DiagramEditPart) {
            return (DiagramEditPart)obj;
        }
        return null;
    }

    public void updateSelectionActions() {
        this.updateActions(this.getSelectionActions());
    }

    public void updateConnectionRouterActions() {
        boolean res = this.isManhattanConnectionRouter();
        ActionRegistry registry = this.getActionRegistry();
        IAction action = registry.getAction((Object)"connectionRouterManhattanId");
        action.setChecked(res);
        action = registry.getAction((Object)"connectionRouterFanId");
        action.setChecked(!res);
    }

    public MenuManager getContextMenu() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null) {
            return viewer.getContextMenu();
        }
        return null;
    }

    public boolean isFanConnectionRouter() {
        boolean res = false;
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        if (diagramEditPart != null) {
            res = diagramEditPart.isFanConnectionRouter();
        }
        return res;
    }

    public void setFanConnectionRouter(boolean res) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        if (diagramEditPart != null) {
            if (res) {
                diagramEditPart.setupFanConnectionRouter();
            } else {
                diagramEditPart.setupManhattanConnectionRouter();
            }
        }
        this.updateConnectionRouterActions();
    }

    public boolean isManhattanConnectionRouter() {
        boolean res = false;
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        if (diagramEditPart != null) {
            res = diagramEditPart.isManhattanConnectionRouter();
        }
        return res;
    }

    public void setManhattanConnectionRouter(boolean res) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        if (diagramEditPart != null) {
            if (res) {
                diagramEditPart.setupManhattanConnectionRouter();
            } else {
                diagramEditPart.setupFanConnectionRouter();
            }
        }
        this.updateConnectionRouterActions();
    }
}

