/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.text.MessageFormat;
import java.util.Date;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import org.apache.log4j.Level;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] LOG_LEVELS = new String[]{"OFF", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "ALL"};
    private Text additionalCommentText;
    private Label sampleLabel;
    private Button showPerspectiveBox;
    private Button useProjectBuildPath;
    private Text maxViolationsPerFilePerRule;
    private Button reviewPmdStyleBox;
    private IPreferences preferences;
    private Text logFileNameText;
    private Scale logLevelScale;
    private Label logLevelValueLabel;
    private Button browseButton;

    public void init(IWorkbench iWorkbench) {
        this.setDescription(this.getMessage("preference.pmd.title"));
        this.preferences = PMDPlugin.getDefault().loadPreferences();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Group group = this.buildGeneralGroup(composite2);
        Group group2 = this.buildReviewGroup(composite2);
        Group group3 = this.buildLoggingGroup(composite2);
        group.setLayoutData((Object)new GridData(768));
        group3.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group2.setLayoutData((Object)gridData);
        return composite2;
    }

    private Group buildGeneralGroup(Composite composite) {
        Group group = new Group(composite, 4);
        group.setText(this.getMessage("preference.pmd.group.general"));
        group.setLayout((Layout)new GridLayout(1, false));
        this.showPerspectiveBox = this.buildShowPerspectiveBoxButton((Composite)group);
        this.useProjectBuildPath = this.buildUseProjectBuildPathButton((Composite)group);
        Label label = new Label((Composite)group, 262);
        this.maxViolationsPerFilePerRule = this.buildMaxViolationsPerFilePerRuleText((Composite)group);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.showPerspectiveBox.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.useProjectBuildPath.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.maxViolationsPerFilePerRule.setLayoutData((Object)gridData);
        return group;
    }

    private Group buildReviewGroup(Composite composite) {
        Group group = new Group(composite, 4);
        group.setText(this.getMessage("preference.pmd.group.review"));
        group.setLayout((Layout)new GridLayout(1, false));
        this.reviewPmdStyleBox = this.buildReviewPmdStyleBoxButton((Composite)group);
        Label label = new Label((Composite)group, 262);
        this.buildLabel((Composite)group, "preference.pmd.label.addcomment");
        this.additionalCommentText = this.buildAdditionalCommentText((Composite)group);
        this.buildLabel((Composite)group, "preference.pmd.label.sample");
        this.sampleLabel = this.buildSampleLabel((Composite)group);
        this.updateSampleLabel();
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.reviewPmdStyleBox.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.additionalCommentText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sampleLabel.setLayoutData((Object)gridData);
        return group;
    }

    private Group buildLoggingGroup(Composite composite) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.horizontalSpan = 3;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.horizontalSpan = 3;
        GridData gridData4 = new GridData();
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalAlignment = 4;
        GridData gridData5 = new GridData();
        gridData5.grabExcessHorizontalSpace = false;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        Group group = new Group(composite, 0);
        group.setText(this.getMessage("preference.pmd.group.logging"));
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText(this.getMessage("preference.pmd.label.log_file_name"));
        label.setLayoutData((Object)gridData5);
        this.logFileNameText = new Text((Composite)group, 2048);
        this.logFileNameText.setText(this.preferences.getLogFileName());
        this.logFileNameText.setToolTipText(this.getMessage("preference.pmd.tooltip.log_file_name"));
        this.logFileNameText.setLayoutData((Object)gridData4);
        this.browseButton = new Button((Composite)group, 0);
        this.browseButton.setText(this.getMessage("preference.pmd.button.browse"));
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GeneralPreferencesPage.this.browseLogFile();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label2 = new Label((Composite)group, 258);
        label2.setLayoutData((Object)gridData2);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.getMessage("preference.pmd.label.log_level"));
        this.logLevelValueLabel = new Label((Composite)group, 0);
        this.logLevelValueLabel.setText("");
        this.logLevelValueLabel.setLayoutData((Object)gridData);
        this.logLevelScale = new Scale((Composite)group, 0);
        this.logLevelScale.setMaximum(6);
        this.logLevelScale.setPageIncrement(1);
        this.logLevelScale.setLayoutData((Object)gridData3);
        this.logLevelScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GeneralPreferencesPage.this.updateLogLevelValueLabel();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GeneralPreferencesPage.this.updateLogLevelValueLabel();
            }
        });
        this.logLevelScale.setSelection(this.intLogLevel(this.preferences.getLogLevel()));
        this.updateLogLevelValueLabel();
        return group;
    }

    private Label buildLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string == null ? "" : this.getMessage(string));
        return label;
    }

    private Label buildSampleLabel(Composite composite) {
        Label label = new Label(composite, 64);
        return label;
    }

    private Text buildAdditionalCommentText(Composite composite) {
        Text text = new Text(composite, 2052);
        text.setText(this.preferences.getReviewAdditionalComment());
        text.setToolTipText(this.getMessage("preference.pmd.tooltip.addcomment"));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GeneralPreferencesPage.this.updateSampleLabel();
            }
        });
        return text;
    }

    private Button buildShowPerspectiveBoxButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.pmd.label.perspective_on_check"));
        button.setSelection(this.preferences.isPmdPerspectiveEnabled());
        return button;
    }

    private Button buildUseProjectBuildPathButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.pmd.label.use_project_build_path"));
        button.setSelection(this.preferences.isProjectBuildPathEnabled());
        return button;
    }

    private Text buildMaxViolationsPerFilePerRuleText(Composite composite) {
        this.buildLabel(composite, "preference.pmd.label.max_violations_pfpr");
        final Text text = new Text(composite, 2052);
        text.setText(String.valueOf(this.preferences.getMaxViolationsPerFilePerRule()));
        text.setToolTipText(this.getMessage("preference.pmd.tooltip.max_violations_pfpr"));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GeneralPreferencesPage.this.validateTextIsNumeric(text);
            }
        });
        return text;
    }

    private Button buildReviewPmdStyleBoxButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.pmd.label.review_pmd_style"));
        button.setSelection(this.preferences.isReviewPmdStyleEnabled());
        return button;
    }

    protected void performDefaults() {
        if (this.additionalCommentText != null) {
            this.additionalCommentText.setText("by {0} on {1}");
        }
        if (this.showPerspectiveBox != null) {
            this.showPerspectiveBox.setSelection(true);
        }
        if (this.useProjectBuildPath != null) {
            this.useProjectBuildPath.setSelection(true);
        }
        if (this.maxViolationsPerFilePerRule != null) {
            this.maxViolationsPerFilePerRule.setText(String.valueOf(5));
        }
        if (this.reviewPmdStyleBox != null) {
            this.reviewPmdStyleBox.setSelection(true);
        }
        if (this.logFileNameText != null) {
            this.logFileNameText.setText("pmd-eclipse.log");
        }
        if (this.logLevelScale != null) {
            this.logLevelScale.setSelection(this.intLogLevel(IPreferences.LOG_LEVEL));
            this.updateLogLevelValueLabel();
        }
    }

    protected void updateSampleLabel() {
        String string = this.additionalCommentText.getText();
        try {
            String string2 = MessageFormat.format(string, System.getProperty("user.name", ""), new Date());
            this.sampleLabel.setText(string2);
            this.setMessage(this.getMessage("preference.pmd.header"), 0);
            this.setValid(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setMessage(this.getMessage("preference.pmd.message.incorrect_format"), 3);
            this.setValid(false);
        }
    }

    protected void validateTextIsNumeric(Text text) {
        try {
            Integer.valueOf(text.getText());
            this.setMessage(this.getMessage("preference.pmd.header"), 0);
            this.setValid(true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(this.getMessage("preference.pmd.message.invalid_numeric_value"), 3);
            this.setValid(false);
        }
    }

    protected void updateLogLevelValueLabel() {
        this.logLevelValueLabel.setText(LOG_LEVELS[this.logLevelScale.getSelection()]);
    }

    protected void browseLogFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(this.getMessage("preference.pmd.dialog.browse"));
        String string = fileDialog.open();
        if (string != null) {
            this.logFileNameText.setText(string);
        }
    }

    public boolean performOk() {
        if (this.additionalCommentText != null) {
            this.preferences.setReviewAdditionalComment(this.additionalCommentText.getText());
        }
        if (this.showPerspectiveBox != null) {
            this.preferences.setPmdPerspectiveEnabled(this.showPerspectiveBox.getSelection());
        }
        if (this.useProjectBuildPath != null) {
            this.preferences.setProjectBuildPathEnabled(this.useProjectBuildPath.getSelection());
        }
        if (this.maxViolationsPerFilePerRule != null) {
            this.preferences.setMaxViolationsPerFilePerRule(Integer.valueOf(this.maxViolationsPerFilePerRule.getText()));
        }
        if (this.reviewPmdStyleBox != null) {
            this.preferences.setReviewPmdStyleEnabled(this.reviewPmdStyleBox.getSelection());
        }
        if (this.logFileNameText != null) {
            this.preferences.setLogFileName(this.logFileNameText.getText());
        }
        if (this.logLevelScale != null) {
            this.preferences.setLogLevel(Level.toLevel((String)LOG_LEVELS[this.logLevelScale.getSelection()]));
        }
        this.preferences.sync();
        PMDPlugin.getDefault().applyLogPreferences(this.preferences);
        return true;
    }

    private int intLogLevel(Level level) {
        int n = 0;
        if (level.equals((Object)Level.OFF)) {
            n = 0;
        } else if (level.equals((Object)Level.FATAL)) {
            n = 1;
        } else if (level.equals((Object)Level.ERROR)) {
            n = 2;
        } else if (level.equals((Object)Level.WARN)) {
            n = 3;
        } else if (level.equals((Object)Level.INFO)) {
            n = 4;
        } else if (level.equals((Object)Level.DEBUG)) {
            n = 5;
        } else if (level.equals((Object)Level.ALL)) {
            n = 6;
        }
        return n;
    }

    private String getMessage(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

