/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleReference;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.rules.XPathRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class RuleDialog
extends Dialog {
    private static final int MODE_ADD = 1;
    private static final int MODE_EDIT = 2;
    private static final int MODE_VIEW = 3;
    protected Text implementationClassText;
    private int mode = 1;
    private Rule editedRule;
    private Rule rule;
    private Text ruleSetNameText;
    private Button ruleReferenceButton;
    private Text sinceText;
    private Text nameText;
    private Button xpathRuleButton;
    private Text messageText;
    private Combo priorityCombo;
    protected Button usesTypeResolutionButton;
    protected Button usesDfaButton;
    private Text descriptionText;
    private Text externalInfoUrlText;
    protected Button openExternalInfoUrlButton;
    private Text exampleText;
    protected Text xpathText;
    private Font courierFont;
    static /* synthetic */ Class class$0;

    public RuleDialog(Shell shell) {
        super(shell);
        this.mode = 1;
    }

    public RuleDialog(Shell shell, Rule rule) {
        super(shell);
        this.mode = 2;
        this.editedRule = rule;
    }

    public RuleDialog(Shell shell, Rule rule, boolean bl) {
        super(shell);
        this.mode = bl ? 2 : 3;
        this.editedRule = rule;
    }

    protected Control createDialogArea(Composite composite) {
        this.courierFont = new Font((Device)this.getShell().getDisplay(), "Courier New", 10, 0);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label = this.buildLabel(composite2, "preference.ruleedit.label.ruleset_name");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.ruleSetNameText = this.buildRuleSetNameText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.ruleSetNameText.setLayoutData((Object)gridData);
        this.ruleReferenceButton = this.buildRuleReferenceButton(composite2);
        Label label2 = this.buildLabel(composite2, "preference.ruleedit.label.since");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label2.setLayoutData((Object)gridData);
        this.sinceText = this.buildSinceText(composite2);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = false;
        this.sinceText.setLayoutData((Object)gridData);
        Label label3 = this.buildLabel(composite2, "preference.ruleedit.label.name");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label3.setLayoutData((Object)gridData);
        this.nameText = this.buildNameText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)gridData);
        this.xpathRuleButton = this.buildXPathRuleButton(composite2);
        Label label4 = this.buildLabel(composite2, "preference.ruleedit.label.implementation_class");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label4.setLayoutData((Object)gridData);
        this.implementationClassText = this.buildImplementationClassText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.implementationClassText.setLayoutData((Object)gridData);
        Label label5 = this.buildLabel(composite2, "preference.ruleedit.label.message");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label5.setLayoutData((Object)gridData);
        this.messageText = this.buildMessageText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.messageText.setLayoutData((Object)gridData);
        Label label6 = this.buildLabel(composite2, "preference.ruleedit.label.priority");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label6.setLayoutData((Object)gridData);
        this.priorityCombo = this.buildPriorityCombo(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.priorityCombo.setLayoutData((Object)gridData);
        this.usesTypeResolutionButton = this.buildUsesTypeResolutionButton(composite2);
        this.usesDfaButton = this.buildUsesDfaButton(composite2);
        Label label7 = this.buildLabel(composite2, "preference.ruleedit.label.description");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label7.setLayoutData((Object)gridData);
        this.descriptionText = this.buildDescriptionText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 300;
        gridData.heightHint = 100;
        this.descriptionText.setLayoutData((Object)gridData);
        Label label8 = this.buildLabel(composite2, "preference.ruleedit.label.external_info_url");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label8.setLayoutData((Object)gridData);
        this.openExternalInfoUrlButton = this.buildOpenExternalInfoUrlButton(composite2);
        this.externalInfoUrlText = this.buildExternalInfoUrlText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.externalInfoUrlText.setLayoutData((Object)gridData);
        Label label9 = this.buildLabel(composite2, "preference.ruleedit.label.examples");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label9.setLayoutData((Object)gridData);
        this.exampleText = this.buildExampleText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 300;
        gridData.heightHint = 70;
        this.exampleText.setLayoutData((Object)gridData);
        Label label10 = this.buildLabel(composite2, "preference.ruleedit.label.xpath");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label10.setLayoutData((Object)gridData);
        this.xpathText = this.buildXPathText(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 300;
        gridData.heightHint = 100;
        this.xpathText.setLayoutData((Object)gridData);
        this.getShell().setText(this.getMessage("preference.ruleset.dialog.title"));
        this.refreshOverridden();
        return composite2;
    }

    private Label buildLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string == null ? "" : this.getMessage(string));
        return label;
    }

    private Text buildRuleSetNameText(Composite composite) {
        Text text = new Text(composite, 2052);
        if (this.mode == 1) {
            text.setText("pmd-eclipse");
            text.setEnabled(false);
        }
        if (this.mode == 2) {
            text.setText(this.editedRule.getRuleSetName());
            text.setEnabled(false);
        }
        if (this.mode == 3) {
            text.setText(this.editedRule.getRuleSetName());
            text.setEnabled(false);
        }
        return text;
    }

    private Button buildRuleReferenceButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.ruleedit.button.rule_reference"));
        button.setEnabled(false);
        button.setSelection(this.editedRule instanceof RuleReference);
        return button;
    }

    private Text buildSinceText(Composite composite) {
        Text text = new Text(composite, 2052);
        text.setEnabled(false);
        String string = "n/a";
        if (this.editedRule != null && this.editedRule.getSince() != null) {
            string = this.editedRule.getSince();
        }
        if (this.mode == 1) {
            text.setText(string);
        }
        if (this.mode == 2) {
            text.setText(string);
        }
        if (this.mode == 3) {
            text.setText(string);
        }
        return text;
    }

    private Text buildNameText(Composite composite) {
        Text text = new Text(composite, 2052);
        if (this.mode == 1) {
            text.setFocus();
        }
        if (this.mode == 2) {
            text.setText(this.editedRule.getName());
            text.setEnabled(false);
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.editedRule.getName());
        }
        return text;
    }

    private Button buildXPathRuleButton(Composite composite) {
        final Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.ruleedit.button.xpath_rule"));
        if (this.mode == 3) {
            button.setVisible(false);
        } else {
            if (this.mode == 2) {
                button.setSelection(this.editedRule.getRuleClass().endsWith("XPathRule"));
                button.setEnabled(false);
            } else {
                button.setEnabled(true);
                button.setSelection(true);
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        Text text = RuleDialog.this.implementationClassText;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("net.sourceforge.pmd.rules.XPathRule");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        text.setText(clazz.getName());
                        RuleDialog.this.implementationClassText.setEnabled(false);
                        RuleDialog.this.xpathText.setEnabled(true);
                        RuleDialog.this.usesTypeResolutionButton.setEnabled(false);
                        RuleDialog.this.usesTypeResolutionButton.setSelection(true);
                        RuleDialog.this.usesDfaButton.setEnabled(false);
                        RuleDialog.this.usesDfaButton.setSelection(false);
                    } else {
                        RuleDialog.this.implementationClassText.setText("");
                        RuleDialog.this.implementationClassText.setEnabled(true);
                        RuleDialog.this.xpathText.setText("");
                        RuleDialog.this.xpathText.setEnabled(false);
                        RuleDialog.this.usesTypeResolutionButton.setEnabled(true);
                        RuleDialog.this.usesTypeResolutionButton.setSelection(true);
                        RuleDialog.this.usesDfaButton.setEnabled(true);
                        RuleDialog.this.usesDfaButton.setSelection(false);
                    }
                }
            });
        }
        return button;
    }

    private Text buildImplementationClassText(Composite composite) {
        Text text = new Text(composite, 2052);
        if (this.mode == 2) {
            text.setText(this.editedRule.getRuleClass());
            text.setEnabled(false);
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.editedRule.getRuleClass());
        }
        if (this.mode == 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sourceforge.pmd.rules.XPathRule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            text.setText(clazz.getName());
            text.setEnabled(false);
        }
        return text;
    }

    private Text buildMessageText(Composite composite) {
        Text text = new Text(composite, 2052);
        if (this.mode == 2) {
            text.setFocus();
            text.setText(this.editedRule.getMessage().trim());
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.editedRule.getMessage().trim());
        }
        return text;
    }

    private Combo buildPriorityCombo(Composite composite) {
        Combo combo = new Combo(composite, 2052);
        String[] stringArray = PMDPlugin.getDefault().getPriorityLabels();
        int n = 2;
        if (this.editedRule != null && this.editedRule.getPriority() >= 0 && this.editedRule.getPriority() <= stringArray.length) {
            n = this.editedRule.getPriority() - 1;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            combo.add(string);
            ++n2;
        }
        combo.select(n);
        if (this.mode == 3) {
            combo.setEnabled(false);
        } else if (this.mode == 2) {
            combo.setEnabled(true);
        } else if (this.mode == 1) {
            combo.setEnabled(true);
        }
        return combo;
    }

    private Button buildUsesTypeResolutionButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.ruleedit.button.uses_type_resolution"));
        if (this.mode == 3) {
            button.setVisible(false);
        } else if (this.mode == 2) {
            button.setEnabled(false);
            button.setSelection(this.editedRule.usesTypeResolution());
        } else {
            button.setEnabled(false);
            button.setSelection(true);
        }
        return button;
    }

    private Button buildUsesDfaButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.ruleedit.button.uses_dfa"));
        if (this.mode == 3) {
            button.setVisible(false);
        } else if (this.mode == 2) {
            button.setEnabled(false);
            button.setSelection(this.editedRule.usesDFA());
        } else {
            button.setEnabled(false);
            button.setSelection(false);
        }
        return button;
    }

    private Text buildDescriptionText(Composite composite) {
        Text text = new Text(composite, 2626);
        String string = null;
        if (this.editedRule != null) {
            string = this.editedRule.getDescription();
        }
        if (string == null) {
            string = "";
        }
        text.setText(string.trim());
        if (this.mode == 3) {
            text.setEditable(false);
        }
        return text;
    }

    private Text buildExternalInfoUrlText(Composite composite) {
        Text text = new Text(composite, 2052);
        String string = null;
        if (this.editedRule != null) {
            string = this.editedRule.getExternalInfoUrl();
        }
        if (string == null) {
            string = "";
        }
        text.setText(string.trim());
        if (this.mode == 3) {
            text.setEditable(false);
        }
        return text;
    }

    private Button buildOpenExternalInfoUrlButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(this.getMessage("preference.ruleedit.button.open_external_info_url"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = RuleDialog.this.externalInfoUrlText.getText().trim();
                if (string.length() > 0) {
                    try {
                        IWebBrowser iWebBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                        iWebBrowser.openURL(new URL(string));
                    }
                    catch (PartInitException partInitException) {
                        partInitException.printStackTrace();
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            }
        });
        return button;
    }

    private String getExamplesString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.editedRule.getExamples().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(((String)iterator.next()).trim());
        }
        return stringBuffer.toString();
    }

    private Text buildExampleText(Composite composite) {
        Text text = new Text(composite, 2818);
        text.setFont(this.courierFont);
        if (this.mode == 2) {
            text.setText(this.getExamplesString());
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.getExamplesString());
        }
        return text;
    }

    private Text buildXPathText(Composite composite) {
        Text text = new Text(composite, 2818);
        text.setFont(this.courierFont);
        if (this.mode == 1) {
            text.setEditable(true);
            text.setEnabled(true);
        }
        if (this.mode == 2 && this.editedRule.hasProperty("xpath")) {
            text.setText(this.editedRule.getStringProperty("xpath").trim());
            text.setEditable(true);
        }
        if (this.mode == 3) {
            text.setEditable(false);
            if (this.editedRule.hasProperty("xpath")) {
                text.setText(this.editedRule.getStringProperty("xpath").trim());
            }
        }
        return text;
    }

    protected void refreshOverridden() {
        if ((this.mode == 2 || this.mode == 3) && this.editedRule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)this.editedRule;
            Color color = new Color(null, 196, 196, 255);
            this.nameText.setBackground((Color)(ruleReference.getOverriddenName() != null ? color : null));
            this.messageText.setBackground((Color)(ruleReference.getOverriddenMessage() != null ? color : null));
            this.priorityCombo.setBackground((Color)(ruleReference.getOverriddenPriority() != null ? color : null));
            this.descriptionText.setBackground((Color)(ruleReference.getOverriddenDescription() != null ? color : null));
            this.externalInfoUrlText.setBackground((Color)(ruleReference.getOverriddenExternalInfoUrl() != null ? color : null));
            this.exampleText.setBackground((Color)(ruleReference.getOverriddenExamples() != null ? color : null));
            this.xpathText.setBackground(ruleReference.getOverriddenProperties() != null && ruleReference.getOverriddenProperties().containsKey("xpath") ? color : null);
        }
    }

    private String getMessage(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }

    protected void okPressed() {
        if (this.validateForm() && this.mode != 3) {
            super.okPressed();
        } else if (this.mode == 3) {
            this.cancelPressed();
        }
    }

    private boolean validateForm() {
        return this.validateName() && this.validatePriority() && this.validateMessage() && this.validateImplementationClass();
    }

    private boolean validateName() {
        boolean bl = true;
        String string = this.nameText.getText();
        if (string.trim().length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.name_mandatory"));
            this.nameText.setFocus();
            bl = false;
        }
        return bl;
    }

    private boolean validatePriority() {
        boolean bl = true;
        if (this.priorityCombo.getSelectionIndex() < 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.priority_mandatory"));
            this.priorityCombo.setFocus();
            bl = false;
        }
        return bl;
    }

    private boolean validateMessage() {
        boolean bl = true;
        String string = this.messageText.getText();
        if (string.trim().length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.message_mandatory"));
            this.messageText.setFocus();
            bl = false;
        }
        return bl;
    }

    private boolean validateImplementationClass() {
        boolean bl;
        boolean bl2;
        block14: {
            bl2 = true;
            bl = false;
            if (this.mode == 1) {
                try {
                    Class<?> clazz = Class.forName(this.implementationClassText.getText());
                    Object obj = clazz.newInstance();
                    if (obj instanceof Rule) {
                        this.rule = (Rule)clazz.newInstance();
                        this.rule.setName(this.nameText.getText().trim());
                        this.rule.setRuleSetName("pmd-eclipse");
                        this.rule.setMessage(this.messageText.getText().trim());
                        this.rule.setDescription(this.descriptionText.getText());
                        this.rule.getExamples().add(this.exampleText.getText());
                        this.rule.setPriority(this.priorityCombo.getSelectionIndex() + 1);
                        this.rule.setExternalInfoUrl(this.externalInfoUrlText.getText());
                        if (this.usesTypeResolutionButton.getSelection()) {
                            this.rule.setUsesTypeResolution();
                        }
                        if (this.usesDfaButton.getSelection()) {
                            this.rule.setUsesDFA();
                        }
                        if (this.rule instanceof XPathRule) {
                            String string = this.xpathText.getText().trim();
                            if (string.length() != 0) {
                                this.rule.addProperty("xpath", string);
                            } else {
                                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.xpath_mandatory"));
                                this.xpathText.setFocus();
                                bl2 = false;
                            }
                        }
                        break block14;
                    }
                    bl = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                }
                catch (InstantiationException instantiationException) {
                    bl = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    bl = true;
                }
            } else {
                this.editedRule.setMessage(this.messageText.getText().trim());
                this.editedRule.setPriority(this.priorityCombo.getSelectionIndex() + 1);
                this.editedRule.setDescription(this.descriptionText.getText());
                this.editedRule.setExternalInfoUrl(this.externalInfoUrlText.getText());
                this.editedRule.addExample(this.exampleText.getText());
                String string = this.xpathText.getText().trim();
                if (string.length() > 0) {
                    this.editedRule.addProperty("xpath", string);
                }
            }
        }
        if (bl) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.class_invalid"));
            this.implementationClassText.setFocus();
            bl2 = false;
        }
        return bl2;
    }

    public Rule getRule() {
        return this.rule;
    }

    protected void cancelPressed() {
        this.courierFont.dispose();
        super.cancelPressed();
    }
}

