/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import net.sourceforge.pmd.eclipse.ui.views.DataflowGraphTableData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class DataflowGraphTable
extends Composite
implements PaintListener {
    private int numRows = 0;
    private int numCols = 0;
    private Integer[] colWidths;
    private Integer rowHeight;
    private Color bgColor;
    private Color fgColor;
    private Color lineColor;
    protected Composite header;
    protected Composite bodyFrame;
    protected Composite bodyArea;
    protected Composite graphArea;
    protected Point tablePosition;
    protected Point tableSize;
    protected int graphColumn = 1;
    protected static final Color DEFAULT_BG_COLOR = new Color(null, 255, 255, 255);
    protected static final Color DEFAULT_FG_COLOR = new Color(null, 0, 0, 0);
    protected static final Color DEFAULT_LINE_COLOR = new Color(null, 192, 192, 192);
    protected static final int DEFAULT_ROW_HEIGHT = 20;
    protected static final int DEFAULT_COL_WIDTH = 100;

    public DataflowGraphTable(Composite composite, int n) {
        super(composite, n);
        this.setLayoutData(new GridData(1808));
        this.header = this.buildTableHeader(this);
        Composite[] compositeArray = this.buildTableBody(this);
        this.bodyFrame = compositeArray[0];
        this.bodyArea = compositeArray[1];
        this.bodyFrame.addPaintListener((PaintListener)this);
        this.bodyArea.addPaintListener((PaintListener)this);
        this.bodyFrame.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                DataflowGraphTable.this.redraw();
            }
        });
        this.initScrollBars(this.bodyFrame);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
    }

    private Composite buildTableHeader(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    private Composite[] buildTableBody(Composite composite) {
        Composite composite2 = new Composite(composite, 768);
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite3.setLayoutData((Object)gridData);
        composite3.setSize(this.numCols * 100, this.numRows * 20);
        int n = 10;
        GridLayout gridLayout = new GridLayout(this.numCols, false);
        gridLayout.marginHeight = gridLayout.marginWidth = n / 2;
        gridLayout.horizontalSpacing = gridLayout.verticalSpacing = n;
        composite3.setLayout((Layout)gridLayout);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.tablePosition = new Point(composite3.getLocation().x, composite3.getLocation().y);
        this.tableSize = new Point(composite3.getSize().x, composite3.getSize().y);
        return new Composite[]{composite2, composite3};
    }

    public void setColumns(int[] nArray, String[] stringArray, int n) {
        this.numCols = nArray.length;
        this.colWidths = new Integer[this.numCols];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.colWidths[n2] = new Integer(nArray[n2]);
            ++n2;
        }
        if (n >= 0 && n <= this.numCols) {
            this.graphColumn = n;
        }
        String[] stringArray2 = this.getHeaderTitles(stringArray);
        GridLayout gridLayout = (GridLayout)this.header.getLayout();
        gridLayout.numColumns = this.numCols + 1;
        int n3 = 0;
        while (n3 <= this.numCols) {
            Button button = new Button(this.header, 0);
            GridData gridData = new GridData();
            if (n3 < this.numCols) {
                button.setText(stringArray2[n3]);
                gridData.widthHint = nArray[n3];
            } else if (n3 == this.numCols) {
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalAlignment = 4;
            }
            button.setLayoutData((Object)gridData);
            ++n3;
        }
        n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            n3 += this.colWidths[n4].intValue();
            ++n4;
        }
        ((GridLayout)this.bodyArea.getLayout()).numColumns = this.numCols;
        this.tableSize.x = n3;
        this.redraw();
    }

    private String[] getHeaderTitles(String[] stringArray) {
        String[] stringArray2 = new String[this.numCols];
        if (stringArray == null) {
            int n = 0;
            while (n < this.numCols) {
                stringArray2[n] = "";
                ++n;
            }
        } else if (stringArray.length < this.numCols) {
            int n = this.numCols - stringArray.length;
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray2[n2] = stringArray[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                stringArray2[stringArray.length + n2] = "";
                ++n2;
            }
        } else {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    public void setRows(int n, int n2) {
        this.numRows = n;
        this.rowHeight = new Integer(n2);
        this.tableSize.y = this.numRows * n2;
        this.redraw();
    }

    public void setColors(Color color, Color color2, Color color3) {
        this.fgColor = color;
        this.bgColor = color2;
        this.lineColor = color3;
        this.bodyArea.setBackground(this.bgColor);
        this.bodyArea.setForeground(this.fgColor);
        this.redraw();
    }

    public void setTableData(ArrayList arrayList) {
        this.buildTableData(this.bodyArea, arrayList);
        this.redraw();
    }

    public Composite getGraphArea() {
        return this.graphArea;
    }

    public void redraw() {
        Point point = this.bodyFrame.getSize();
        Point point2 = this.getParent().getSize();
        Point point3 = new Point(0, 0);
        if (point.equals((Object)point3) && !point2.equals((Object)point3)) {
            this.bodyFrame.setSize(point2);
        }
        this.syncScrollBars(this.bodyFrame);
        this.syncViewPosition(this.bodyFrame);
        this.syncHeader();
        super.redraw();
    }

    private void initScrollBars(Composite composite) {
        ScrollBar scrollBar = composite.getHorizontalBar();
        scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataflowGraphTable.this.scrollHorizontally((ScrollBar)selectionEvent.widget);
            }
        });
        ScrollBar scrollBar2 = composite.getVerticalBar();
        scrollBar2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataflowGraphTable.this.scrollVertically((ScrollBar)selectionEvent.widget);
            }
        });
    }

    private void syncScrollBars(Composite composite) {
        int n = composite.getSize().x - composite.getVerticalBar().getSize().x;
        int n2 = composite.getSize().y - composite.getHorizontalBar().getSize().y;
        ScrollBar scrollBar = this.bodyFrame.getHorizontalBar();
        ScrollBar scrollBar2 = this.bodyFrame.getVerticalBar();
        scrollBar.setEnabled(true);
        scrollBar2.setEnabled(true);
        if (n >= this.tableSize.x) {
            scrollBar.setEnabled(false);
        } else {
            scrollBar.setMaximum(this.tableSize.x);
            scrollBar.setIncrement(this.tableSize.x / 100);
            scrollBar.setPageIncrement(this.tableSize.x);
            scrollBar.setThumb(n);
        }
        if (n2 >= this.tableSize.y) {
            scrollBar2.setEnabled(false);
        } else {
            scrollBar2.setMaximum(this.tableSize.y);
            scrollBar2.setIncrement(this.tableSize.y / 100);
            scrollBar2.setPageIncrement(this.tableSize.y);
            scrollBar2.setThumb(n2);
        }
    }

    private void syncViewPosition(Composite composite) {
        this.tablePosition.x = -this.bodyFrame.getHorizontalBar().getSelection();
        this.tablePosition.y = -this.bodyFrame.getVerticalBar().getSelection();
        int n = composite.getSize().x - composite.getVerticalBar().getSize().x;
        int n2 = composite.getSize().y - composite.getHorizontalBar().getSize().y;
        if (n > this.tableSize.x) {
            this.tablePosition.x = 0;
        }
        if (n2 > this.tableSize.y) {
            this.tablePosition.y = 0;
        }
    }

    protected void syncHeader() {
        Control[] controlArray = this.header.getChildren();
        int n = 0;
        int n2 = 0;
        while (n2 < controlArray.length) {
            Button button = (Button)controlArray[n2];
            button.setLocation(this.tablePosition.x + n, button.getLocation().y);
            n += button.getSize().x;
            if (n2 == controlArray.length - 1) {
                button.setSize(button.getSize().x - this.tablePosition.x, button.getSize().y);
            }
            ++n2;
        }
    }

    protected void scrollHorizontally(ScrollBar scrollBar) {
        int n = scrollBar.getSelection();
        int n2 = this.bodyArea.getLocation().y;
        this.bodyArea.setLocation(-n, n2);
        this.tablePosition.x = -n;
        this.syncHeader();
    }

    protected void scrollVertically(ScrollBar scrollBar) {
        int n = this.bodyArea.getLocation().x;
        int n2 = scrollBar.getSelection();
        this.bodyArea.setLocation(n, -n2);
        this.tablePosition.y = -n2;
    }

    public void paintControl(PaintEvent paintEvent) {
        Composite composite = (Composite)paintEvent.getSource();
        this.bodyArea.getClientArea().width = this.tableSize.x;
        this.bodyArea.getClientArea().height = this.tableSize.y;
        this.bodyArea.setSize(this.tableSize);
        this.bodyArea.setLocation(this.tablePosition);
        if (composite.equals(this.bodyFrame)) {
            this.buildFrameLines(paintEvent.gc);
        } else if (composite.equals(this.bodyArea)) {
            this.buildBodyLines(paintEvent.gc);
            this.clearGraphArea(paintEvent.gc);
            this.bodyFrame.redraw();
        }
    }

    protected void clearGraphArea(GC gC) {
        int n;
        if (this.colWidths == null || this.rowHeight == null) {
            return;
        }
        int n2 = 0;
        if (this.graphColumn > 0) {
            n = 0;
            while (n < this.graphColumn) {
                n2 += this.colWidths[n].intValue();
                ++n;
            }
        }
        n = this.colWidths[this.graphColumn];
        int n3 = this.numRows * this.rowHeight;
        Color color = gC.getBackground();
        if (this.bgColor == null) {
            this.bgColor = DEFAULT_BG_COLOR;
        }
        gC.setBackground(this.bgColor);
        gC.fillRectangle(n2, 1, n - 1, n3);
        if (color == null) {
            color = this.bgColor;
        }
        gC.setBackground(this.bgColor);
    }

    protected void buildBodyLines(GC gC) {
        if (this.lineColor == null) {
            this.lineColor = DEFAULT_LINE_COLOR;
        }
        gC.setForeground(this.lineColor);
        if (this.rowHeight == null) {
            this.rowHeight = new Integer(20);
        }
        int n = this.tableSize.x;
        int n2 = 0;
        while (n2 <= this.numRows) {
            gC.drawLine(0, n2 * this.rowHeight, n, n2 * this.rowHeight);
            ++n2;
        }
        n2 = this.tableSize.y;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.numCols) {
            n3 = this.colWidths == null ? (n3 += 100) : (n3 += this.colWidths[n4].intValue());
            gC.drawLine(n3 - 1, 0, n3 - 1, n2);
            ++n4;
        }
    }

    protected void buildFrameLines(GC gC) {
        int n;
        int n2;
        if (this.bgColor == null) {
            this.bgColor = DEFAULT_BG_COLOR;
        }
        this.bodyFrame.setBackground(this.bgColor);
        if (this.lineColor == null) {
            this.lineColor = DEFAULT_LINE_COLOR;
        }
        gC.setForeground(this.lineColor);
        int n3 = this.tablePosition.x;
        int n4 = this.tablePosition.y;
        if (this.rowHeight == null) {
            this.rowHeight = new Integer(20);
        }
        if ((n2 = this.bodyFrame.getSize().x) > this.tableSize.x) {
            n = 0;
            while (n < this.numRows) {
                gC.drawLine(this.tableSize.x, n4 + n * this.rowHeight, n2, n4 + n * this.rowHeight);
                ++n;
            }
        }
        if ((n = this.bodyFrame.getSize().y) > this.tableSize.y) {
            int n5 = n4 + this.tableSize.y;
            while (n5 < n) {
                gC.drawLine(0, n5, n2, n5);
                n5 += this.rowHeight.intValue();
            }
            n5 = n4 + this.tableSize.y;
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.numCols) {
                n6 = this.colWidths == null ? (n6 += 100) : (n6 += this.colWidths[n7].intValue());
                gC.drawLine(n3 + n6 - 1, n5, n3 + n6 - 1, n);
                ++n7;
            }
        }
    }

    private void buildTableData(Composite composite, ArrayList arrayList) {
        if (this.bgColor == null) {
            this.bgColor = DEFAULT_BG_COLOR;
        }
        if (this.fgColor == null) {
            this.fgColor = DEFAULT_FG_COLOR;
        }
        int n = ((GridLayout)composite.getLayout()).horizontalSpacing;
        int n2 = ((GridLayout)composite.getLayout()).verticalSpacing;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(n3);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.numCols) {
                DataflowGraphTableData dataflowGraphTableData = (DataflowGraphTableData)arrayList2.get(n7);
                String string = "";
                int n8 = 0;
                if (dataflowGraphTableData != null) {
                    string = dataflowGraphTableData.getData().toString();
                    n8 = dataflowGraphTableData.getStyle();
                }
                n5 = this.colWidths[n7] - n;
                n6 = this.rowHeight - n2;
                if (n7 == this.graphColumn) {
                    if (n3 == 0) {
                        this.graphArea = this.createGraphArea(composite, this.bgColor, this.fgColor, new Point(n4, n3 * this.rowHeight), new Point(n5, this.numRows * n6));
                    } else {
                        n4 += this.colWidths[n7].intValue();
                    }
                } else {
                    this.createLabel(composite, n8, string, this.bgColor, this.fgColor, new Point(n4, n3 * this.rowHeight), new Point(n5, n6));
                    n4 += this.colWidths[n7].intValue();
                }
                ++n7;
            }
            ++n3;
        }
    }

    protected void createLabel(Composite composite, int n, String string, Color color, Color color2, Point point, Point point2) {
        Label label = new Label(composite, n);
        GridData gridData = new GridData();
        gridData.widthHint = point2.x;
        gridData.heightHint = point2.y;
        label.setLayoutData((Object)gridData);
        label.setLocation(point.x, point.y);
        label.setBackground(color);
        label.setText(string == null ? "" : string);
    }

    private Composite createGraphArea(Composite composite, Color color, Color color2, Point point, Point point2) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1040);
        gridData.widthHint = point2.x;
        gridData.heightHint = point2.y;
        gridData.verticalSpan = this.numRows;
        composite2.setLayoutData((Object)gridData);
        composite2.setSize(point2);
        composite2.setLayout((Layout)new FillLayout());
        return composite2;
    }
}

