/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PriorityFilter
extends ViewerFilter {
    private List priorityList = new ArrayList<Integer>(Arrays.asList(PMDPlugin.getDefault().getPriorityValues()));

    public boolean select(Viewer viewer, Object object, Object object2) {
        boolean bl = false;
        if (object2 instanceof PackageRecord) {
            bl = this.hasMarkersToShow((PackageRecord)object2);
        } else if (object2 instanceof FileRecord) {
            bl = this.hasMarkersToShow((FileRecord)object2);
        } else if (object2 instanceof IMarker) {
            try {
                IMarker iMarker = (IMarker)object2;
                Integer n = (Integer)iMarker.getAttribute("pmd_priority");
                bl = this.isPriorityEnabled(n);
            }
            catch (CoreException coreException) {
                PMDPlugin.getDefault().logError("message.error.core_exception" + ((Object)((Object)this)).toString(), coreException);
            }
        } else if (object2 instanceof MarkerRecord) {
            MarkerRecord markerRecord = (MarkerRecord)object2;
            int n = 0;
            while (n < this.priorityList.size()) {
                Integer n2 = (Integer)this.priorityList.get(n);
                if (markerRecord.getPriority() == n2.intValue()) {
                    bl = true;
                    break;
                }
                ++n;
            }
        } else if (object2 instanceof FileToMarkerRecord) {
            bl = true;
        }
        return bl;
    }

    private boolean isPriorityEnabled(Integer n) {
        boolean bl = false;
        if (n != null) {
            int n2 = 0;
            while (n2 < this.priorityList.size()) {
                Integer n3 = (Integer)this.priorityList.get(n2);
                if (n.equals(n3)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private boolean hasMarkersToShow(AbstractPMDRecord abstractPMDRecord) {
        boolean bl = false;
        int n = 0;
        while (n < this.priorityList.size()) {
            Integer n2 = (Integer)this.priorityList.get(n);
            IMarker[] iMarkerArray = abstractPMDRecord.findMarkersByAttribute("pmd_priority", n2);
            if (iMarkerArray.length > 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void setPriorityFilterList(List list) {
        this.priorityList = list;
    }

    public List getPriorityFilterList() {
        return this.priorityList;
    }

    public void addPriorityToList(Integer n) {
        this.priorityList.add(n);
    }

    public void removePriorityFromList(Integer n) {
        this.priorityList.remove(n);
    }

    public void setPriorityFilterListFromString(String string, String string2) {
        if (string != null) {
            String[] stringArray = string.split(string2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(new Integer(stringArray[n]));
                ++n;
            }
            this.priorityList = arrayList;
        }
    }

    public String getPriorityFilterListAsString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.priorityList.size()) {
            if (n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(this.priorityList.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }
}

