/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.meta.impl.XActionItemImpl;
import org.jboss.tools.common.meta.impl.XMetaDataLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XActionListImpl
extends XActionItemImpl
implements XActionList {
    private XActionItem[] items;
    private short groupfactor = 0;
    private Element element = null;

    public void setElement(Element element) {
        this.element = element;
        if (element != null) {
            super.load(element);
        }
    }

    public XActionItem getByPath(String path) {
        if (path == null) {
            return this.getItem(path);
        }
        return this.findItem(path);
    }

    public boolean isLoaded() {
        return this.element == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (this.isLoaded()) {
            return;
        }
        XActionListImpl xActionListImpl = this;
        synchronized (xActionListImpl) {
            if (this.element == null) {
                return;
            }
            this.load(this.element);
            this.element = null;
        }
    }

    public void print(String off) {
        XActionItem[] is = this.getActionItems();
        int i = 0;
        while (i < is.length) {
            XActionItemImpl item = (XActionItemImpl)is[i];
            if (item instanceof XActionListImpl) {
                ((XActionListImpl)item).print(String.valueOf(off) + "  ");
            }
            ++i;
        }
    }

    @Override
    public XActionItem[] getActionItems() {
        return this.items;
    }

    @Override
    public short getGroupFactor() {
        return this.groupfactor;
    }

    @Override
    public XActionItem getItem(String name) {
        if (name == null) {
            ModelPlugin.getDefault().logWarning("XActionListImpl.getItem: name=null");
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].getName().equals(name)) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    public XActionItem findItem(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, "./");
        XActionItem item = this;
        while (st.hasMoreTokens() && item != null) {
            String part = st.nextToken();
            item = item.getItem(part);
        }
        return item;
    }

    @Override
    public XAction getAction(String path) {
        XActionItem item = this.findItem(path);
        return item instanceof XAction ? (XAction)item : null;
    }

    @Override
    public void load(Element el) {
        super.load(el);
        this.groupfactor = (short)XMetaDataLoader.getInt(el, "group", 0);
        NodeList ns = el.getChildNodes();
        ArrayList<XActionItem> list = new ArrayList<XActionItem>();
        int i = 0;
        while (i < ns.getLength()) {
            Node n = ns.item(i);
            if (n.getNodeType() == 1) {
                Element ei = (Element)n;
                String tag = ei.getNodeName();
                if ("XActionItem".equals(tag)) {
                    String kind = ei.getAttribute("kind");
                    XActionItemImpl item = kind.equals("list") ? new XActionListImpl() : new XActionImpl();
                    item.setParent(this);
                    item.load(ei);
                    list.add(item);
                } else if ("XActionItemReference".equals(tag)) {
                    XActionItem item;
                    String entityName = ei.getAttribute("entity");
                    String attrName = ei.getAttribute("name");
                    String defaultPath = this.getPath() == null ? attrName : String.valueOf(this.getPath()) + "/" + attrName;
                    String path = ei.hasAttribute("path") ? ei.getAttribute("path") : defaultPath;
                    XModelEntity entity = this.getMetaModel().getEntity(entityName);
                    if (entity != null && (item = ((XActionListImpl)entity.getActionList()).findItem(path)) != null) {
                        list.add(item.copy(XActionItem.Acceptor.DEFAULT));
                    }
                }
            }
            ++i;
        }
        this.items = list.toArray(new XActionItem[list.size()]);
    }

    public void merge(XActionListImpl ext) {
        this.validate();
        XActionItem[] ext_items = ext.getActionItems();
        HashSet<String> set = new HashSet<String>();
        ArrayList<XActionItem> l = new ArrayList<XActionItem>();
        int i = 0;
        while (i < this.items.length) {
            set.add(this.items[i].getName());
            ++i;
        }
        i = 0;
        while (i < ext_items.length) {
            String n = ext_items[i].getName();
            if (!set.contains(n)) {
                ((XActionItemImpl)ext_items[i]).setParent(this);
                l.add(ext_items[i]);
            } else {
                XActionItem item = this.getItem(n);
                if (item instanceof XActionListImpl && ext_items[i] instanceof XActionListImpl) {
                    ((XActionListImpl)item).merge((XActionListImpl)ext_items[i]);
                }
            }
            ++i;
        }
        if (l.size() == 0) {
            return;
        }
        XActionItem[] nc = new XActionItem[this.items.length + l.size()];
        int i2 = 0;
        while (i2 < this.items.length) {
            nc[i2] = this.items[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < l.size()) {
            nc[this.items.length + i2] = (XActionItem)l.get(i2);
            ++i2;
        }
        this.items = nc;
    }

    @Override
    public XActionItem copy(XActionItem.Acceptor acceptor) {
        if (!acceptor.accepts(this)) {
            return null;
        }
        XActionListImpl item = (XActionListImpl)super.copy(acceptor);
        item.groupfactor = this.groupfactor;
        ArrayList<XActionItem> l = new ArrayList<XActionItem>();
        int i = 0;
        while (i < this.items.length) {
            XActionItem ic = this.items[i].copy(acceptor);
            if (ic != null) {
                l.add(ic);
            }
            ++i;
        }
        item.items = l.toArray(new XActionItem[l.size()]);
        return item;
    }

    @Override
    protected XActionItemImpl createInstance() {
        return new XActionListImpl();
    }

    public void addActionItem(XActionItem item) {
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].getName().equals(item.getName())) {
                return;
            }
            ++i;
        }
        XActionItem[] is = new XActionItem[this.items.length + 1];
        System.arraycopy(this.items, 0, is, 0, this.items.length);
        is[this.items.length] = item;
        this.items = is;
    }
}

