/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.model.plugin.ModelPlugin;

public class XJob
extends WorkspaceJob {
    public static Object FAMILY_XJOB = new Object();
    private static boolean suspended = false;
    static XJob JOB = new XJob();
    Set<String> ids = new HashSet<String>();
    List<XRunnable> list = new ArrayList<XRunnable>();
    boolean running = false;

    public static void addRunnable(XRunnable runnable) {
        JOB.addRunnableInternal(runnable);
    }

    public static void addRunnableWithPriority(XRunnable runnable) {
        JOB.addRunnableInternalWithPriority(runnable);
    }

    public static void waitForJob() throws InterruptedException {
        XJob.waitForJob(false);
    }

    public static void waitForJob(boolean immediateOnly) throws InterruptedException {
        boolean stop;
        Object[] o = new Object[]{FAMILY_XJOB, ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourcesPlugin.FAMILY_AUTO_BUILD};
        do {
            Job running;
            stop = true;
            int i = 0;
            while (i < o.length) {
                Job[] js = Platform.getJobManager().find(o[i]);
                if (js != null && js.length > 0) {
                    Platform.getJobManager().join(o[i], (IProgressMonitor)new NullProgressMonitor());
                    stop = false;
                }
                ++i;
            }
            if (!stop || immediateOnly || (running = XJob.getJobRunning(10)) == null) continue;
            running.join();
            stop = false;
        } while (!stop);
    }

    public static Job getJobRunning(int iterationLimit) {
        Job[] js = Platform.getJobManager().find(null);
        Job dm = null;
        if (js != null) {
            int i = 0;
            while (i < js.length) {
                if (js[i].getState() == 4 && js[i].getThread() != Thread.currentThread() && !(js[i] instanceof UIJob)) {
                    if (js[i].belongsTo(DecoratorManager.FAMILY_DECORATE)) {
                        dm = js[i];
                    } else {
                        return js[i];
                    }
                }
                ++i;
            }
        }
        if (dm != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            if (iterationLimit > 0) {
                return XJob.getJobRunning(iterationLimit - 1);
            }
        }
        return null;
    }

    public XJob() {
        super("JBoss Tools Model Update");
        this.setSystem(true);
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY_XJOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRunnableInternal(XRunnable runnable) {
        if (!XJob.isSuspended()) {
            XJob xJob = this;
            synchronized (xJob) {
                if (this.ids.contains(runnable.getId())) {
                    return;
                }
                this.ids.add(runnable.getId());
                this.list.add(runnable);
            }
            if (this.getState() == 0 || !this.isRunning()) {
                this.schedule(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        XJob xJob = this;
        synchronized (xJob) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRunnableInternalWithPriority(XRunnable runnable) {
        if (!XJob.isSuspended()) {
            XJob xJob = this;
            synchronized (xJob) {
                if (this.ids.contains(runnable.getId())) {
                    return;
                }
                this.ids.add(runnable.getId());
                this.list.add(0, runnable);
            }
            if (this.getState() == 0 || !this.isRunning()) {
                this.schedule(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        XJob xJob = this;
        synchronized (xJob) {
            this.running = true;
        }
        while (true) {
            XRunnable r = null;
            XJob xJob2 = this;
            synchronized (xJob2) {
                if (this.list.size() == 0) {
                    this.running = false;
                    break;
                }
                r = this.list.remove(0);
            }
            xJob2 = this;
            synchronized (xJob2) {
                this.ids.remove(r.getId());
            }
            if (XJob.isSuspended()) continue;
            try {
                r.run();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    XJob xJob3 = this;
                    synchronized (xJob3) {
                        this.running = false;
                    }
                    throw (RuntimeException)e;
                }
                ModelPlugin.getDefault().logError("Error in job " + r.getId(), e);
            }
        }
        return Status.OK_STATUS;
    }

    public static boolean isSuspended() {
        return suspended;
    }

    public static void setSuspended(boolean suspended) {
        XJob.suspended = suspended;
    }

    public static interface XRunnable
    extends Runnable {
        public String getId();
    }
}

