/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.files.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.files.handlers.TargetHolder;
import org.jboss.tools.common.model.filesystems.impl.CreateFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelMessages;

public class CreateFolderSupport
extends SpecialWizardSupport {
    protected TargetHolder targetHolder = new TargetHolder();
    protected DefaultWizardDataValidator validator = this.createValidator();

    @Override
    public void reset() {
        this.targetHolder.setAction(this.action);
        this.targetHolder.target = this.getTarget();
        IResource r = (IResource)this.getTarget().getAdapter(IResource.class);
        if (r == null) {
            this.setAttributeValue(0, "folder", "");
            this.targetHolder.revalidate(null);
        } else {
            this.targetHolder.revalidate(r.getFullPath().toString());
            this.setAttributeValue(0, "folder", this.targetHolder.path);
        }
    }

    @Override
    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            if (!this.checkResource()) {
                return;
            }
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    @Override
    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL, HELP};
    }

    protected boolean checkResource() {
        if (this.targetHolder.addPath.length() == 0) {
            return true;
        }
        ServiceDialog d = this.getTarget().getModel().getService();
        String message = MessageFormat.format("Folder {0} does not exist. Do you want to create it?", this.targetHolder.path);
        int q = d.showDialog(ModelMessages.WARNING, message, new String[]{SpecialWizardSupport.OK, SpecialWizardSupport.CANCEL}, null, 0);
        return q == 0;
    }

    public boolean canCreateResource(String path) {
        if (this.targetHolder.target == null) {
            return false;
        }
        if (path == null || path.length() == 0 || path.indexOf(42) >= 0) {
            return false;
        }
        return this.isCorrectPath(path) && !this.resourceExists(path);
    }

    boolean isCorrectPath(String path) {
        return (path = this.revalidatePath(path)) != null && !path.equals("/") && path.indexOf("//") < 0;
    }

    boolean resourceExists(String path) {
        if (path == null || this.targetHolder.target == null) {
            return false;
        }
        if ((path = this.revalidatePath(path)).startsWith("/")) {
            path = path.substring(1);
        }
        return this.targetHolder.target.getChildByPath(path) != null;
    }

    protected String revalidatePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (this.targetHolder.addPath.length() > 0) {
            path = String.valueOf(this.targetHolder.addPath) + path;
        }
        return path;
    }

    protected void execute() throws XModelException {
        Properties p = this.extractStepData(0);
        String path = p.getProperty("name");
        XModelObject f = this.createFolder(path = this.revalidatePath(path));
        if (f != null) {
            this.targetHolder.saveLastPath();
        }
    }

    protected XModelObject createFolder(String path) throws XModelException {
        if (!this.canCreateResource(path)) {
            return null;
        }
        XModelObject fs = this.targetHolder.target;
        StringTokenizer st = new StringTokenizer(path, "/");
        int c = st.countTokens();
        int i = 0;
        while (i < c) {
            String s = st.nextToken();
            XModelObject o = fs.getChildByPath(s);
            if (o == null) {
                o = fs.getModel().createModelObject("FileFolder", null);
                o.setAttributeValue("name", s);
                DefaultCreateHandler.addCreatedObject(fs, o, this.getProperties());
                ((FolderImpl)o).save();
            }
            fs = o;
            ++i;
        }
        return fs;
    }

    protected final XModelObject getTargetFolder() {
        return this.targetHolder.target;
    }

    @Override
    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport(this, step);
        return this.validator;
    }

    protected DefaultWizardDataValidator createValidator() {
        return new Validator();
    }

    @Override
    public String getFocusAttribute(int stepId) {
        if (stepId == 0) {
            return "name";
        }
        return super.getFocusAttribute(stepId);
    }

    protected class Validator
    extends DefaultWizardDataValidator {
        String FORBIDDEN_INDICES = "\"\n\t*\\/:<>?|";
        String FORBIDDEN_FOLDER_LETTERS = "\"\n\t*:<>?|";

        protected Validator() {
        }

        @Override
        public void validate(Properties data) {
            String folder = data.getProperty("folder");
            CreateFolderSupport.this.targetHolder.revalidate(folder);
            this.message = null;
            if (CreateFolderSupport.this.targetHolder.target == null) {
                this.message = "Cannot create folder in specified folder.";
                return;
            }
            this.validateFolderName();
            if (this.message != null) {
                return;
            }
            this.validateChildName(data);
            if (this.message != null) {
                return;
            }
            super.validate(data);
        }

        protected void validateChildName(Properties data) {
            if (this.message != null) {
                return;
            }
            String name = data.getProperty("name");
            if (name == null || name.length() == 0) {
                return;
            }
            if (name.equals(".")) {
                this.message = "Incorrect name.";
            } else if (name.endsWith(".") && name.indexOf(46) != name.lastIndexOf(46)) {
                this.message = "Name must not end in a period.";
            } else {
                int i = 0;
                while (i < this.FORBIDDEN_INDICES.length()) {
                    if (name.indexOf(this.FORBIDDEN_INDICES.charAt(i)) >= 0) {
                        this.message = MessageFormat.format("Name must not contain character {0} .", Character.valueOf(this.FORBIDDEN_INDICES.charAt(i)));
                        return;
                    }
                    ++i;
                }
            }
        }

        private void validateFolderName() {
            if (CreateFolderSupport.this.targetHolder.addPath.length() == 0) {
                return;
            }
            int i = 0;
            while (i < this.FORBIDDEN_FOLDER_LETTERS.length()) {
                if (CreateFolderSupport.this.targetHolder.addPath.indexOf(this.FORBIDDEN_FOLDER_LETTERS.charAt(i)) >= 0) {
                    this.message = MessageFormat.format("Folder name must not contain character {0} .", Character.valueOf(this.FORBIDDEN_FOLDER_LETTERS.charAt(i)));
                    return;
                }
                ++i;
            }
        }

        @Override
        protected void validateAddFile(XEntityData[] ds, Properties data) {
            CreateFileHandler.validateNameAndExtension(CreateFolderSupport.this.action, data, null);
            if (CreateFolderSupport.this.targetHolder.target != null) {
                String entity = CreateFolderSupport.this.action.getProperty("entity");
                if (entity == null) {
                    entity = CreateFolderSupport.this.getEntityData()[this.step].getModelEntity().getName();
                }
                if (!(CreateFolderSupport.this.targetHolder.addPath != null && CreateFolderSupport.this.targetHolder.addPath.length() != 0 || this.checkChild(CreateFolderSupport.this.targetHolder.target, entity, data))) {
                    return;
                }
            } else {
                this.message = "Cannot create file in specified folder.";
            }
        }
    }
}

