/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaElementAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaWorkbenchAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsLoader;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsRenameListener;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.impl.OrderedObjectImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class FileSystemsImpl
extends OrderedObjectImpl
implements IResourceChangeListener {
    private static final long serialVersionUID = 1527918897367197051L;
    boolean needsUpdateOverlapping = false;
    protected Set<String> overlapped = null;
    Ov overlapper = null;
    FileSystemsRenameListener fileSystemsRenameListener = new FileSystemsRenameListener(this);
    Libs libs = new Libs(this);
    private static int OV_SLEEPING = 0;
    private static int OV_STOPPED = 1;
    private static int OV_RUNNING = 2;
    UpdateRunnable currentUpdate = null;
    int lock = 0;
    private boolean isUpdating = false;
    boolean saveRequested = false;
    private IContributorResourceAdapter contributorResourceAdapter = null;

    public FileSystemsImpl() {
        IWorkspace workspace = ModelPlugin.getWorkspace();
        if (workspace != null) {
            workspace.addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public Libs getLibs() {
        return this.libs;
    }

    @Override
    protected void onSetEntity(String entity) {
        super.onSetEntity(entity);
        this.libs.init();
    }

    @Override
    public String getPresentationString() {
        IProject p = EclipseResourceUtil.getProject(this);
        String app = this.getAttributeValue("application name");
        if (p != null && !app.equals(p.getName())) {
            app = app.length() > 0 ? String.valueOf(p.getName()) + " (" + app + ")" : p.getName();
        }
        return app != null && app.length() > 0 ? app : super.getPresentationString();
    }

    @Override
    public boolean addChild_0(XModelObject o) {
        boolean b = super.addChild_0(o);
        if (b && o instanceof FileSystemImpl && o.isActive()) {
            ((FileSystemImpl)o).getResource();
        }
        if (b) {
            this.updateOverlappedLater();
        }
        return b;
    }

    @Override
    public void removeChild_0(XModelObject o) {
        super.removeChild_0(o);
        this.updateOverlappedLater();
    }

    private void updateOverlappedLater() {
        if (this.isActive() && this.overlapper == null) {
            if (EclipseResourceUtil.isProjectFragment(this.getModel())) {
                return;
            }
            this.needsUpdateOverlapping = true;
            this.overlapper = new Ov();
            XJob.addRunnable(this.overlapper);
        }
    }

    public boolean updateOverlapped() {
        if (this.overlapper != null && this.overlapper.status == OV_RUNNING) {
            return false;
        }
        if (this.overlapper != null) {
            this.overlapper.status = OV_STOPPED;
            this.overlapper = null;
        }
        this.updateOverlappedInternal();
        return true;
    }

    private void updateOverlappedInternal() {
        XModelObject c;
        if (!this.needsUpdateOverlapping) {
            return;
        }
        this.needsUpdateOverlapping = false;
        if (EclipseResourceUtil.isProjectFragment(this.getModel())) {
            return;
        }
        if (this.overlapped == null) {
            this.overlapped = new HashSet<String>();
        }
        HashSet<String> _overlapped = new HashSet<String>();
        HashMap<String, String> overlappedSystems = new HashMap<String, String>();
        XModelObject[] cs = this.getChildren();
        String[] paths = new String[cs.length];
        int i = 0;
        while (i < cs.length) {
            String path = XModelObjectUtil.getExpandedValue(cs[i], "location", null);
            try {
                File f = new File(path);
                path = f.getCanonicalPath().replace('\\', '/');
                path = FilePathHelper.toPathPath(path);
                if (path.charAt(path.length() - 1) != '/') {
                    path = String.valueOf(path) + '/';
                }
                paths[i] = path;
            }
            catch (IOException iOException) {
                paths[i] = null;
            }
            ++i;
        }
        i = 0;
        while (i < paths.length) {
            if (paths[i] != null) {
                int j = 0;
                while (j < paths.length) {
                    if (i != j && paths[j] != null && paths[i].startsWith(paths[j]) && (!paths[i].equals(paths[j]) || j >= i)) {
                        String overlap = String.valueOf(cs[j].getPathPart()) + paths[i].substring(paths[j].length() - 1, paths[i].length() - 1);
                        _overlapped.add(overlap);
                        overlappedSystems.put(overlap, cs[i].getPath());
                    }
                    ++j;
                }
            }
            ++i;
        }
        ArrayList<XModelObject> fire = new ArrayList<XModelObject>();
        Iterator<String> it = this.overlapped.iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (_overlapped.contains(path)) {
                c = this.getChildByPath(path);
                if (c != null && !"true".equals(c.get("overlapped"))) continue;
                _overlapped.remove(path);
                continue;
            }
            it.remove();
            c = this.getChildByPath(path);
            if (c == null) continue;
            c.set("overlapped", "");
            c.set("overlappedSystem", "");
            c = c.getParent();
            if (c == null) continue;
            fire.add(c);
        }
        for (String path : _overlapped) {
            this.overlapped.add(path);
            c = this.getChildByPath(path);
            if (c == null) continue;
            c.set("overlapped", "true");
            c.set("overlappedSystem", (String)overlappedSystems.get(path));
            c = c.getParent();
            if (c == null) continue;
            fire.add(c);
        }
        XModelObject[] os = fire.toArray(new XModelObject[0]);
        int i2 = 0;
        while (i2 < os.length) {
            ((XModelImpl)this.getModel()).fireStructureChanged(os[i2]);
            ++i2;
        }
        if (this.overlapped.size() == 0) {
            this.overlapped = null;
        }
    }

    public boolean isOverlapped(XModelObject o) {
        return this.overlapped != null && this.overlapped.contains(o.getPath());
    }

    @Override
    public String get(String name) {
        if ("APPLICATION_NAME".equals(name) || "application-name".equals(name)) {
            String s = super.get(name);
            if (s == null || s.length() == 0) {
                s = "";
            }
            return s == null ? "" : s;
        }
        return super.get(name);
    }

    public void forceUpdate() {
        if (this.currentUpdate != null) {
            this.currentUpdate.run();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IFile f;
        if (!this.isActive() || event == null || event.getDelta() == null) {
            return;
        }
        if (!this.checkDelta(event.getDelta())) {
            return;
        }
        List<IResourceDelta> fileDeltas = this.findFileDeltas(event.getDelta(), null);
        if (fileDeltas != null) {
            boolean onlyMarkers = true;
            for (IResourceDelta d : fileDeltas) {
                if (d.getKind() != 4) {
                    onlyMarkers = false;
                    break;
                }
                int flags = d.getFlags();
                if (flags == 131072) continue;
                onlyMarkers = false;
                break;
            }
            if (onlyMarkers) {
                return;
            }
        }
        IFile iFile = f = fileDeltas == null || fileDeltas.size() == 0 ? null : (IFile)fileDeltas.get(0).getResource();
        if (f != null && f.getName().equals(".classpath")) {
            new FileSystemsLoader().updateClassPath(this);
            return;
        }
        this.fileSystemsRenameListener.checkFileSystemRename(event);
        this.requireUpdate();
    }

    List<IResourceDelta> findFileDeltas(IResourceDelta delta, List<IResourceDelta> fileDeltas) {
        IResourceDelta[] ds;
        IResource r = delta.getResource();
        if (r instanceof IFile) {
            if (fileDeltas == null) {
                fileDeltas = new ArrayList<IResourceDelta>();
            }
            fileDeltas.add(delta);
        }
        IResourceDelta[] iResourceDeltaArray = ds = delta.getAffectedChildren();
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta d = iResourceDeltaArray[n2];
            fileDeltas = this.findFileDeltas(d, fileDeltas);
            ++n2;
        }
        return fileDeltas;
    }

    private void onUpdateClassPath() {
    }

    void requireUpdate() {
        if (this.lock == 0 && this.currentUpdate == null) {
            this.currentUpdate = new UpdateRunnable();
            XJob.addRunnableWithPriority(this.currentUpdate);
        } else if (this.currentUpdate != null) {
            ++this.currentUpdate.request;
        }
    }

    boolean checkDelta(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if (resource instanceof IWorkspaceRoot) {
            IResourceDelta[] d = delta.getAffectedChildren();
            return d.length > 0 && this.checkDelta(d[0]);
        }
        IProject p = resource.getProject();
        IProject cp = EclipseResourceUtil.getProject(this);
        return cp == null || cp == p || p == null;
    }

    public void lockUpdate() {
        ++this.lock;
    }

    public void unlockUpdate() {
        --this.lock;
    }

    public boolean requestSave() {
        if (this.isUpdating) {
            this.saveRequested = true;
        }
        return this.isUpdating;
    }

    private void doUpdate() {
        if (this.lock > 0) {
            return;
        }
        this.isUpdating = true;
        try {
            boolean b = this.isOpenProject();
            if (b) {
                XModelObjectLoaderUtil.getObjectLoader(this).update(this);
            }
        }
        catch (XModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)((Object)e));
        }
        if (this.saveRequested) {
            try {
                XModelObjectLoaderUtil.getObjectLoader(this).save(this);
            }
            finally {
                this.saveRequested = false;
                this.isUpdating = false;
            }
        }
        this.isUpdating = false;
    }

    private boolean isOpenProject() {
        IProject p = EclipseResourceUtil.getProject(this);
        return p != null && p.isAccessible() && p.isOpen();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IResource.class == adapter || IProject.class == adapter) {
            return EclipseResourceUtil.getProject(this);
        }
        if (IContributorResourceAdapter.class == adapter) {
            if (this.contributorResourceAdapter == null) {
                this.contributorResourceAdapter = new ExtendedJavaElementAdapterFactory();
            }
            return this.contributorResourceAdapter;
        }
        if (IWorkbenchAdapter.class == adapter) {
            return new ExtendedJavaWorkbenchAdapter();
        }
        if (IContributorResourceAdapter.class == adapter) {
            return new IContributorResourceAdapterImpl();
        }
        return super.getAdapter(adapter);
    }

    private IAdaptable validateAdaptable(IAdaptable adaptable) {
        IProject p;
        IJavaProject a = null;
        if (adaptable instanceof XModelObject && (p = EclipseResourceUtil.getProject(this)) != null) {
            a = EclipseResourceUtil.getJavaProject((IProject)p);
        }
        return a == null ? adaptable : a;
    }

    static /* synthetic */ int access$0() {
        return OV_SLEEPING;
    }

    class ExtendedJavaElementAdapterFactory
    extends JavaElementAdapterFactory {
        ExtendedJavaElementAdapterFactory() {
        }

        public IResource getAdaptedResource(IAdaptable adaptable) {
            return super.getAdaptedResource(FileSystemsImpl.this.validateAdaptable(adaptable));
        }
    }

    class ExtendedJavaWorkbenchAdapter
    extends JavaWorkbenchAdapter {
        ExtendedJavaWorkbenchAdapter() {
        }

        public Object[] getChildren(Object element) {
            return super.getChildren((Object)this.getJavaElement(element));
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            return super.getImageDescriptor((Object)this.getJavaElement(element));
        }

        public String getLabel(Object element) {
            return super.getLabel((Object)this.getJavaElement(element));
        }

        public Object getParent(Object element) {
            return super.getLabel((Object)this.getJavaElement(element));
        }

        private IJavaElement getJavaElement(Object element) {
            if (element instanceof IJavaElement) {
                return (IJavaElement)element;
            }
            IProject p = EclipseResourceUtil.getProject(FileSystemsImpl.this);
            return EclipseResourceUtil.getJavaProject((IProject)p);
        }
    }

    class IContributorResourceAdapterImpl
    implements IContributorResourceAdapter {
        IContributorResourceAdapterImpl() {
        }

        public IResource getAdaptedResource(IAdaptable adaptable) {
            return EclipseResourceUtil.getProject(FileSystemsImpl.this);
        }
    }

    class Ov
    implements XJob.XRunnable {
        int status = FileSystemsImpl.access$0();

        Ov() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.status == OV_STOPPED) {
                return;
            }
            this.status = OV_RUNNING;
            try {
                FileSystemsImpl.this.updateOverlappedInternal();
            }
            finally {
                FileSystemsImpl.this.overlapper = null;
            }
        }

        @Override
        public String getId() {
            return "Model:update overlapped: " + XModelConstants.getWorkspace(FileSystemsImpl.this.getModel());
        }
    }

    class UpdateRunnable
    implements XJob.XRunnable {
        String id;
        int request;
        int usage;

        UpdateRunnable() {
            this.id = "Update File Systems - " + XModelConstants.getWorkspace(FileSystemsImpl.this.getModel());
            this.request = 0;
            this.usage = 0;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void run() {
            if (this != FileSystemsImpl.this.currentUpdate) {
                return;
            }
            if (!FileSystemsImpl.this.isActive()) {
                ModelPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)FileSystemsImpl.this);
            } else {
                FileSystemsImpl.this.doUpdate();
                if (this.request != 0) {
                    this.request = 0;
                    FileSystemsImpl.this.doUpdate();
                }
            }
            if (this == FileSystemsImpl.this.currentUpdate) {
                FileSystemsImpl.this.currentUpdate = null;
            }
        }
    }
}

