/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.project.ext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.filesystems.impl.LibsListener;

public abstract class AbstractClassPathMonitor<P>
implements LibsListener {
    protected XModel model = null;
    protected P project;
    protected List<String> paths = new ArrayList<String>();
    private boolean loaded = false;
    protected Map<IPath, String> paths2 = new HashMap<IPath, String>();
    boolean libsModified = false;
    protected Set<String> processedPaths = new HashSet<String>();

    public P getProject() {
        return this.project;
    }

    public void init() {
        if (this.model == null) {
            return;
        }
        Libs libs = FileSystemsHelper.getLibs(this.model);
        if (libs != null) {
            libs.addListener(this);
        }
    }

    public abstract IProject getProjectResource();

    public synchronized boolean update() {
        boolean result;
        Libs libs = FileSystemsHelper.getLibs(this.model);
        if (libs == null) {
            return false;
        }
        libs.update();
        List<String> newPaths = libs.getPaths();
        boolean bl = result = this.libsModified || !this.loaded;
        if (newPaths != null) {
            this.paths = newPaths;
            this.loaded = true;
        } else {
            this.paths = new ArrayList<String>();
            this.loaded = false;
        }
        if (result) {
            this.paths2.clear();
            this.paths2.putAll(libs.getPathsAsMap());
        }
        this.libsModified = false;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pathLoaded(IPath path) {
        String p = this.paths2.get(path);
        if (p != null) {
            AbstractClassPathMonitor abstractClassPathMonitor = this;
            synchronized (abstractClassPathMonitor) {
                this.processedPaths.add(p);
            }
        }
    }

    public boolean hasPath(IPath path) {
        return this.paths2.get(path) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Libs libs = FileSystemsHelper.getLibs(this.model);
        if (libs != null) {
            libs.requestForUpdate();
        }
        this.paths = new ArrayList<String>();
        this.loaded = false;
        if (this.paths2 != null) {
            this.paths2.clear();
        }
        AbstractClassPathMonitor abstractClassPathMonitor = this;
        synchronized (abstractClassPathMonitor) {
            this.processedPaths.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> syncProcessedPaths() {
        ArrayList<String> removed = new ArrayList<String>();
        AbstractClassPathMonitor abstractClassPathMonitor = this;
        synchronized (abstractClassPathMonitor) {
            Iterator<String> it = this.processedPaths.iterator();
            while (it.hasNext()) {
                String p = it.next();
                if (this.paths.contains(p)) continue;
                removed.add(p);
                it.remove();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requestForLoad(String p) {
        AbstractClassPathMonitor abstractClassPathMonitor = this;
        synchronized (abstractClassPathMonitor) {
            return this.processedPaths.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pathsChanged(List<String> paths) {
        AbstractClassPathMonitor abstractClassPathMonitor = this;
        synchronized (abstractClassPathMonitor) {
            this.libsModified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void libraryChanged(String path) {
        AbstractClassPathMonitor abstractClassPathMonitor = this;
        synchronized (abstractClassPathMonitor) {
            this.libsModified = true;
            this.processedPaths.remove(path);
        }
    }
}

