/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsSaveParticipant;
import de.tobject.findbugs.builder.FindBugsBuilder;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.io.FileOutput;
import de.tobject.findbugs.io.IO;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.nature.FindBugsNature;
import de.tobject.findbugs.preferences.FindBugsConstants;
import de.tobject.findbugs.preferences.FindBugsPreferenceInitializer;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.view.IMarkerSelectionHandler;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionAssociations;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindbugsPlugin
extends AbstractUIPlugin {
    public static final String ICON_PATH = "icons/";
    public static final String DETAILS_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    public static final String USER_ANNOTATIONS_VIEW_ID = "de.tobject.findbugs.view.userannotationsview";
    public static final String TREE_VIEW_ID = "de.tobject.findbugs.view.bugtreeview";
    public static final String BUG_CONTENT_PROVIDER_ID = "de.tobject.findbugs.view.explorer.BugContentProvider";
    private final Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>(13);
    public static boolean DEBUG;
    public static final String PLUGIN_ID = "edu.umd.cs.findbugs.plugin.eclipse";
    public static final String BUILDER_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder";
    public static final String NATURE_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsNature";
    private static final String PLUGIN_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/plugin";
    private static final String BUILDER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/builder";
    private static final String NATURE_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/nature";
    private static final String REPORTER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/reporter";
    private static final String CONTENT_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/content";
    private static final String PROFILER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/profiler";
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION;
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION_DIRTY;
    public static final QualifiedName SESSION_PROPERTY_USERPREFS;
    public static final QualifiedName SESSION_PROPERTY_SETTINGS_ON;
    public static final String LIST_DELIMITER = ";";
    private static FindbugsPlugin plugin;
    private ResourceBundle resourceBundle;
    private BugResolutionAssociations bugResolutions;

    public FindbugsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        try {
            this.resourceBundle = ResourceBundle.getBundle("de.tobject.findbugs.messages");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        String findBugsHome = FindbugsPlugin.getFindBugsEnginePluginLocation();
        if (DEBUG) {
            this.logInfo("Looking for FindBugs detectors in: " + findBugsHome);
        }
        System.setProperty("findbugs.home", findBugsHome);
        FindbugsSaveParticipant saveParticipant = new FindbugsSaveParticipant();
        ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)saveParticipant);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        for (FindBugsMarker.Priority prio : FindBugsMarker.Priority.values()) {
            ImageDescriptor descriptor = this.getImageDescriptor(prio.iconName());
            if (descriptor == null) continue;
            reg.put(prio.iconName(), descriptor);
        }
    }

    public static FindbugsPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Display.getCurrent() != null) {
            return FindbugsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        }
        final IWorkbenchWindow[] window = new IWorkbenchWindow[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                window[0] = FindbugsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            }
        });
        return window[0];
    }

    public static Shell getShell() {
        IWorkbenchWindow window = FindbugsPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = FindbugsPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void configurePluginDebugOptions() {
        if (this.isDebugging()) {
            String option = Platform.getDebugOption((String)PLUGIN_DEBUG);
            DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)BUILDER_DEBUG);
            FindBugsWorker.DEBUG = FindBugsBuilder.DEBUG = Boolean.valueOf(option).booleanValue();
            option = Platform.getDebugOption((String)NATURE_DEBUG);
            FindBugsNature.DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)REPORTER_DEBUG);
            Reporter.DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)CONTENT_DEBUG);
            BugContentProvider.DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)PROFILER_DEBUG);
            if (Boolean.valueOf(option).booleanValue()) {
                System.setProperty("profiler.report", "true");
            }
        }
    }

    public static String getFindBugsEnginePluginLocation() {
        URL u = plugin.getBundle().getEntry("/");
        try {
            URL bundleRoot = FileLocator.resolve((URL)u);
            if (FindBugsBuilder.DEBUG) {
                System.out.println("Pluginpath: " + bundleRoot.getPath());
            }
            return bundleRoot.getPath();
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "IO Exception locating engine plugin");
            return null;
        }
    }

    public String getMessage(String key) {
        return FindbugsPlugin.getResourceString(key);
    }

    public void logException(Throwable e, String message) {
        this.logMessage(4, message, e);
    }

    public void logError(String message) {
        this.logMessage(4, message, null);
    }

    public void logWarning(String message) {
        this.logMessage(2, message, null);
    }

    public void logInfo(String message) {
        this.logMessage(1, message, null);
    }

    public void logMessage(int severity, String message, Throwable e) {
        if (DEBUG) {
            String what = severity == 4 ? (e != null ? "Exception" : "Error") : "Warning";
            System.out.println(what + " in FindBugs plugin: " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        IStatus status = FindbugsPlugin.createStatus(severity, message, e);
        this.getLog().log(status);
    }

    public static IStatus createStatus(int severity, String message, Throwable e) {
        return new Status(severity, PLUGIN_ID, 0, message, e);
    }

    public static IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, PLUGIN_ID, 0, message, e);
    }

    private static IPath getBugCollectionFile(IProject project) {
        IPath path = FindbugsPlugin.getDefault().getStateLocation();
        return path.append(project.getName() + ".fbwarnings");
    }

    private static boolean isBugCollectionDirty(IProject project) throws CoreException {
        Object dirty = project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY);
        if (dirty == null) {
            return false;
        }
        return (Boolean)dirty;
    }

    public static void markBugCollectionDirty(IProject project, boolean isDirty) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY, (Object)(isDirty ? Boolean.TRUE : Boolean.FALSE));
    }

    public static SortedBugCollection getBugCollection(IProject project, IProgressMonitor monitor) throws CoreException {
        SortedBugCollection bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
        if (bugCollection == null) {
            try {
                FindbugsPlugin.readBugCollectionAndProject(project, monitor);
                bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
            catch (DocumentException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
        }
        return bugCollection;
    }

    private static void cacheBugCollectionAndProject(IProject project, SortedBugCollection bugCollection, Project fbProject) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    private static SortedBugCollection createDefaultEmptyBugCollection(IProject project) throws CoreException {
        SortedBugCollection bugCollection = new SortedBugCollection();
        Project fbProject = new Project();
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, fbProject);
        return bugCollection;
    }

    private static void readBugCollectionAndProject(IProject project, IProgressMonitor monitor) throws IOException, DocumentException, CoreException {
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        if (!bugCollectionFile.exists()) {
            FindbugsPlugin.getDefault().logInfo("creating new bug collection: " + bugCollectionPath.toOSString());
            FindbugsPlugin.createDefaultEmptyBugCollection(project);
            return;
        }
        SortedBugCollection bugCollection = new SortedBugCollection();
        bugCollection.readXML(bugCollectionFile);
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, bugCollection.getProject());
    }

    public static void storeBugCollection(IProject project, SortedBugCollection bugCollection, IProgressMonitor monitor) throws IOException, CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        if (bugCollection != null) {
            FindbugsPlugin.writeBugCollection(project, bugCollection, monitor);
        }
    }

    public static void saveCurrentBugCollection(IProject project, IProgressMonitor monitor) throws CoreException {
        SortedBugCollection bugCollection;
        if (FindbugsPlugin.isBugCollectionDirty(project) && (bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION)) != null) {
            FindbugsPlugin.writeBugCollection(project, bugCollection, monitor);
        }
    }

    private static void writeBugCollection(IProject project, final SortedBugCollection bugCollection, IProgressMonitor monitor) throws CoreException {
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        FileOutput fileOutput = new FileOutput(){

            public void writeFile(OutputStream os) throws IOException {
                bugCollection.writeXML(os);
            }

            public String getTaskDescription() {
                return "creating XML FindBugs data file";
            }
        };
        IO.writeFile(bugCollectionFile, fileOutput, monitor);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    private static IFile getUserPreferencesFile(IProject project) {
        return project.getFile(".fbprefs");
    }

    public static boolean isProjectSettingsEnabled(IProject project) {
        Boolean enabled;
        try {
            enabled = (Boolean)project.getSessionProperty(SESSION_PROPERTY_SETTINGS_ON);
        }
        catch (CoreException e) {
            enabled = null;
        }
        if (enabled != null) {
            return enabled;
        }
        IFile file = FindbugsPlugin.getUserPreferencesFile(project);
        boolean projectPropsEnabled = file.isAccessible();
        if (projectPropsEnabled) {
            ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), PLUGIN_ID);
            projectPropsEnabled = !store.contains("disableProjectProps") || !store.getBoolean("disableProjectProps");
        }
        FindbugsPlugin.setProjectSettingsEnabled(project, null, projectPropsEnabled);
        return projectPropsEnabled;
    }

    public static void setProjectSettingsEnabled(IProject project, IPreferenceStore store, boolean enabled) {
        try {
            project.setSessionProperty(SESSION_PROPERTY_SETTINGS_ON, (Object)enabled);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error setting FindBugs session property for project");
        }
        if (store != null) {
            store.setValue("disableProjectProps", !enabled);
        }
    }

    public static UserPreferences getUserPreferences(IProject project, boolean forceRead) {
        if (project == null || !FindbugsPlugin.isProjectSettingsEnabled(project)) {
            return FindbugsPlugin.getWorkspacePreferences();
        }
        return FindbugsPlugin.getProjectPreferences(project, forceRead);
    }

    public static UserPreferences getProjectPreferences(IProject project, boolean forceRead) {
        try {
            UserPreferences prefs = (UserPreferences)project.getSessionProperty(SESSION_PROPERTY_USERPREFS);
            if (prefs == null || forceRead) {
                prefs = FindbugsPlugin.readUserPreferences(project);
                if (prefs == null) {
                    prefs = (UserPreferences)FindbugsPlugin.getWorkspacePreferences().clone();
                }
                project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)prefs);
            }
            return prefs;
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error getting FindBugs preferences for project");
            return (UserPreferences)FindbugsPlugin.getWorkspacePreferences().clone();
        }
    }

    private static UserPreferences getWorkspacePreferences() {
        IPath path = FindbugsPlugin.getDefault().getStateLocation().append(".fbprefs");
        UserPreferences userPrefs = FindBugsPreferenceInitializer.createDefaultUserPreferences();
        File prefsFile = path.toFile();
        if (!prefsFile.isFile()) {
            return userPrefs;
        }
        try {
            FileInputStream in = new FileInputStream(prefsFile);
            userPrefs.read(in);
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Error reading custom FindBugs preferences for workspace");
        }
        return userPrefs;
    }

    public static UserPreferences getUserPreferences(IProject project) {
        return FindbugsPlugin.getUserPreferences(project, false);
    }

    public static void saveUserPreferences(IProject project, final UserPreferences userPrefs) throws CoreException {
        FileOutput userPrefsOutput = new FileOutput(){

            public void writeFile(OutputStream os) throws IOException {
                userPrefs.write(os);
            }

            public String getTaskDescription() {
                return "writing user preferences";
            }
        };
        if (project != null) {
            project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)userPrefs);
            IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
            FindbugsPlugin.ensureReadWrite(userPrefsFile);
            IO.writeFile(userPrefsFile, userPrefsOutput, null);
        } else {
            IPath path = FindbugsPlugin.getDefault().getStateLocation();
            path = path.append(".fbprefs");
            IO.writeFile(path.toFile(), userPrefsOutput, null);
        }
    }

    private static void ensureReadWrite(IFile file) throws CoreException {
        IStatus checkOutStatus;
        if (file.isReadOnly() && !(checkOutStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
            throw new CoreException(checkOutStatus);
        }
    }

    private static UserPreferences readUserPreferences(IProject project) throws CoreException {
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        if (!userPrefsFile.exists()) {
            return null;
        }
        try {
            InputStream in = userPrefsFile.getContents(true);
            UserPreferences userPrefs = FindBugsPreferenceInitializer.createDefaultUserPreferences();
            userPrefs.read(in);
            return userPrefs;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not read user preferences for project");
            return null;
        }
    }

    public BugResolutionAssociations getBugResolutions() {
        if (this.bugResolutions == null) {
            this.bugResolutions = this.loadBugResolutions();
        }
        return this.bugResolutions;
    }

    private BugResolutionAssociations loadBugResolutions() {
        BugResolutionLoader loader = new BugResolutionLoader();
        File xmlFile = new File(FindBugs.getHome() + File.separator + "plugin" + File.separator + "findbugs-resolutions.xml");
        return loader.loadBugResolutions(xmlFile);
    }

    public static void showMarker(IMarker marker, String viewId, IWorkbenchPart source) {
        IViewPart view;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (!page.isPartVisible((IWorkbenchPart)(view = page.findView(viewId)))) {
            try {
                view = page.showView(viewId);
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open view: " + viewId);
                return;
            }
        }
        if (view instanceof IMarkerSelectionHandler) {
            IMarkerSelectionHandler handler = (IMarkerSelectionHandler)view;
            handler.markerSelected(marker);
        } else if (DETAILS_VIEW_ID.equals(viewId) && view instanceof ISelectionListener) {
            ISelectionListener listener = (ISelectionListener)view;
            listener.selectionChanged(source, (ISelection)new StructuredSelection((Object)marker));
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        ImageDescriptor imageDescriptor = this.imageDescriptors.get(id);
        if (imageDescriptor == null) {
            String pluginId = FindbugsPlugin.getDefault().getBundle().getSymbolicName();
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)(ICON_PATH + id));
            this.imageDescriptors.put(id, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Set<BugPattern> getKnownPatterns() {
        TreeSet<BugPattern> patterns = new TreeSet<BugPattern>();
        Iterator<BugPattern> patternIterator = I18N.instance().bugPatternIterator();
        while (patternIterator.hasNext()) {
            patterns.add(patternIterator.next());
        }
        return patterns;
    }

    public static Set<BugCode> getKnownPatternTypes() {
        TreeSet<BugCode> patterns = new TreeSet<BugCode>();
        Iterator<BugCode> patternIterator = I18N.instance().bugCodeIterator();
        while (patternIterator.hasNext()) {
            patterns.add(patternIterator.next());
        }
        return patterns;
    }

    public static Set<String> getFilteredIds() {
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        String lastUsedFilter = store.getString("lastUsedExportFilter");
        return FindBugsConstants.decodeIds(lastUsedFilter);
    }

    public static Set<BugPattern> getFilteredPatterns() {
        Iterator<BugPattern> patternIterator = I18N.instance().bugPatternIterator();
        HashSet<BugPattern> set = new HashSet<BugPattern>();
        Set<String> patternTypes = FindbugsPlugin.getFilteredIds();
        while (patternIterator.hasNext()) {
            BugPattern next = patternIterator.next();
            String patternId = next.getType();
            if (!patternTypes.contains(patternId)) continue;
            set.add(next);
        }
        return set;
    }

    public static Set<BugCode> getFilteredPatternTypes() {
        Iterator<BugCode> patternIterator = I18N.instance().bugCodeIterator();
        HashSet<BugCode> set = new HashSet<BugCode>();
        Set<String> patternTypes = FindbugsPlugin.getFilteredIds();
        while (patternIterator.hasNext()) {
            BugCode next = patternIterator.next();
            String type = next.getAbbrev();
            if (!patternTypes.contains(type)) continue;
            set.add(next);
        }
        return set;
    }

    public static void clearBugCollection(IProject project) throws CoreException {
        FindbugsPlugin.createDefaultEmptyBugCollection(project);
        FindbugsPlugin.markBugCollectionDirty(project, true);
        FindbugsPlugin.saveCurrentBugCollection(project, null);
    }

    static {
        SESSION_PROPERTY_BUG_COLLECTION = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection");
        SESSION_PROPERTY_BUG_COLLECTION_DIRTY = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection.dirty");
        SESSION_PROPERTY_USERPREFS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "userprefs");
        SESSION_PROPERTY_SETTINGS_ON = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "settingsOn");
    }
}

