/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.FilterBugsDialog;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class FilterBugsDialogAction
implements IViewActionDelegate {
    private CommonNavigator navigator;

    public void init(IViewPart view) {
        if (view instanceof CommonNavigator) {
            this.navigator = (CommonNavigator)view;
        }
    }

    public void run(IAction action) {
        if (this.navigator == null) {
            return;
        }
        Set<BugPattern> filtered = FindbugsPlugin.getFilteredPatterns();
        Set<BugCode> filteredTypes = FindbugsPlugin.getFilteredPatternTypes();
        FilterBugsDialog dialog = new FilterBugsDialog(this.navigator.getSite().getShell(), filtered, filteredTypes);
        dialog.setTitle("Bug Filter Configuration");
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        String selectedIds = dialog.getSelectedIds();
        FindbugsPlugin.getDefault().getPreferenceStore().setValue("lastUsedExportFilter", selectedIds);
        BugContentProvider provider = BugContentProvider.getProvider(this.navigator.getNavigatorContentService());
        provider.refreshFilters();
        CommonViewer viewer = this.navigator.getCommonViewer();
        Object[] expandedElements = viewer.getExpandedElements();
        viewer.refresh(true);
        viewer.setExpandedElements(expandedElements);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.navigator == null) {
            action.setEnabled(false);
            return;
        }
        BugContentProvider provider = BugContentProvider.getProvider(this.navigator.getNavigatorContentService());
        action.setEnabled(provider.getGrouping() != null);
    }
}

