/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.GroupType;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ShowInPackageExplorerAction
implements IObjectActionDelegate {
    private IWorkbenchPartSite site;
    private Object data;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
    }

    public void run(IAction action) {
        if (this.data == null) {
            return;
        }
        IViewPart part = this.getView("org.eclipse.jdt.ui.PackageExplorer");
        if (part instanceof ISetSelectionTarget) {
            ISetSelectionTarget target = (ISetSelectionTarget)part;
            target.selectReveal((ISelection)new StructuredSelection(this.data));
        }
    }

    private IViewPart getView(String id) {
        try {
            IViewPart part = this.site.getPage().showView(id);
            return part;
        }
        catch (PartInitException e) {
            FindbugsPlugin.getDefault().logException(e, "Can't open view: " + id);
            return null;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            this.data = null;
            action.setEnabled(false);
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            this.data = null;
            action.setEnabled(false);
            return;
        }
        Object firstElement = ss.getFirstElement();
        if (firstElement instanceof IMarker) {
            IMarker marker = (IMarker)firstElement;
            this.data = marker.getResource();
            action.setEnabled(this.data != null);
            return;
        }
        if (!(firstElement instanceof BugGroup)) {
            this.data = null;
            action.setEnabled(false);
            return;
        }
        BugGroup group = (BugGroup)firstElement;
        if (group.getType() == GroupType.Class || group.getType() == GroupType.Package || group.getType() == GroupType.Project) {
            this.data = group.getData();
            action.setEnabled(this.data != null);
        } else {
            this.data = null;
            action.setEnabled(false);
        }
    }
}

