/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.PDEClassPathGenerator;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.builder.WorkItem;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.util.Util;
import de.tobject.findbugs.view.FindBugsConsole;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.workflow.Update;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsWorker {
    public static boolean DEBUG;
    private final IProgressMonitor monitor;
    private final UserPreferences userPrefs;
    private final IProject project;
    private final IJavaProject javaProject;
    private Util.StopTimer st;

    public FindBugsWorker(IProject project, IProgressMonitor monitor) throws CoreException {
        this.project = project;
        this.javaProject = JavaCore.create((IProject)project);
        if (this.javaProject == null || !this.javaProject.exists() || !this.javaProject.getProject().isOpen()) {
            throw new CoreException(FindbugsPlugin.createErrorStatus("Java project is not open or does not exist: " + project, null));
        }
        this.monitor = monitor;
        this.userPrefs = FindbugsPlugin.getUserPreferences(project);
    }

    public void work(List<WorkItem> resources) throws CoreException {
        String[] classPathEntries;
        if (resources == null || resources.isEmpty()) {
            if (DEBUG) {
                FindbugsPlugin.getDefault().logInfo("No resources to analyse for project " + this.project);
            }
            return;
        }
        if (DEBUG) {
            System.out.println(resources);
        }
        this.st = new Util.StopTimer();
        this.st.newPoint("clearMarkers");
        this.clearMarkers(resources);
        this.st.newPoint("configureOutputFiles");
        Project findBugsProject = new Project();
        findBugsProject.setProjectName(this.javaProject.getElementName());
        Reporter bugReporter = new Reporter(this.javaProject, this.monitor);
        if (FindBugsConsole.getConsole() != null) {
            bugReporter.setReportingStream(FindBugsConsole.getConsole().newOutputStream());
        }
        bugReporter.setPriorityThreshold(this.userPrefs.getUserDetectorThreshold());
        FindBugs.setHome(FindbugsPlugin.getFindBugsEnginePluginLocation());
        Map<IPath, IPath> outLocations = this.createOutputLocations();
        this.collectClassFiles(resources, outLocations, findBugsProject);
        this.configureSourceDirectories(findBugsProject, outLocations);
        if (findBugsProject.getFileCount() == 0) {
            if (DEBUG) {
                FindbugsPlugin.getDefault().logInfo("No resources to analyse for project " + this.project);
            }
            return;
        }
        this.st.newPoint("createAuxClasspath");
        for (String entry : classPathEntries = this.createAuxClasspath()) {
            findBugsProject.addAuxClasspathEntry(entry);
        }
        this.st.newPoint("configureProps");
        FindBugs2 findBugs = new FindBugs2();
        findBugs.setNoClassOk(true);
        findBugs.setProject(findBugsProject);
        findBugs.setBugReporter(bugReporter);
        findBugs.setProgressCallback(bugReporter);
        findBugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        findBugs.setUserPreferences(this.userPrefs);
        findBugs.setAnalysisFeatureSettings(this.userPrefs.getAnalysisFeatureSettings());
        findBugs.setMergeSimilarWarnings(false);
        this.configureExtendedProps(this.userPrefs.getIncludeFilterFiles(), findBugs, true, false);
        this.configureExtendedProps(this.userPrefs.getExcludeFilterFiles(), findBugs, false, false);
        this.configureExtendedProps(this.userPrefs.getExcludeBugsFiles(), findBugs, false, true);
        this.st.newPoint("runFindBugs");
        this.runFindBugs(findBugs);
        boolean incremental = !(resources.get(0) instanceof IProject);
        this.updateBugCollection(findBugsProject, bugReporter, incremental);
        this.st.newPoint("done");
        this.st = null;
        this.monitor.done();
    }

    private void configureSourceDirectories(Project findBugsProject, Map<IPath, IPath> outLocations) {
        Set<IPath> srcDirs = outLocations.keySet();
        for (IPath iPath : srcDirs) {
            findBugsProject.addSourceDir(iPath.toOSString());
        }
    }

    public void loadXml(String fileName) throws CoreException {
        if (fileName == null) {
            return;
        }
        this.st = new Util.StopTimer();
        this.clearMarkers(null);
        Project findBugsProject = new Project();
        Reporter bugReporter = new Reporter(this.javaProject, this.monitor);
        bugReporter.setPriorityThreshold(this.userPrefs.getUserDetectorThreshold());
        this.reportFromXml(fileName, findBugsProject, bugReporter);
        this.updateBugCollection(findBugsProject, bugReporter, false);
        this.monitor.done();
    }

    private void clearMarkers(List<WorkItem> files) throws CoreException {
        if (files == null) {
            this.project.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
            return;
        }
        for (WorkItem item : files) {
            if (item == null) continue;
            item.clearMarkers();
        }
    }

    private void collectClassFiles(List<WorkItem> resources, Map<IPath, IPath> outLocations, Project fbProject) {
        for (WorkItem resource : resources) {
            resource.addFilesToProject(fbProject, outLocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFindBugs(FindBugs2 findBugs) {
        try {
            findBugs.execute();
        }
        catch (InterruptedException e) {
            if (DEBUG) {
                FindbugsPlugin.getDefault().logException(e, "Worker interrupted");
            }
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs analysis");
        }
        finally {
            findBugs.dispose();
        }
    }

    private void updateBugCollection(Project findBugsProject, Reporter bugReporter, boolean incremental) {
        SortedBugCollection newBugCollection = bugReporter.getBugCollection();
        try {
            this.st.newPoint("getBugCollection");
            SortedBugCollection oldBugCollection = FindbugsPlugin.getBugCollection(this.project, this.monitor);
            this.st.newPoint("mergeBugCollections");
            SortedBugCollection resultCollection = this.mergeBugCollections(oldBugCollection, newBugCollection, incremental);
            resultCollection.setTimestamp(System.currentTimeMillis());
            this.st.newPoint("storeBugCollection");
            FindbugsPlugin.storeBugCollection(this.project, resultCollection, this.monitor);
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs results update");
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs results update");
        }
        this.st.newPoint("createMarkers");
        MarkerUtil.createMarkers(this.javaProject, newBugCollection, this.monitor);
    }

    private SortedBugCollection mergeBugCollections(SortedBugCollection firstCollection, SortedBugCollection secondCollection, boolean incremental) {
        Update update = new Update();
        boolean copyDeadBugs = incremental;
        SortedBugCollection merged = (SortedBugCollection)update.mergeCollections(firstCollection, secondCollection, copyDeadBugs, incremental);
        return merged;
    }

    private void configureExtendedProps(Collection<String> filterFiles, IFindBugsEngine findBugs, boolean include, boolean bugsFilter) {
        for (String filePath : filterFiles) {
            IPath path = FindBugsWorker.getFilterPath(filePath, this.project);
            if (!path.toFile().exists()) {
                FindbugsPlugin.getDefault().logWarning("Filter not found: " + filePath);
                continue;
            }
            String filterName = path.toOSString();
            try {
                if (bugsFilter) {
                    findBugs.excludeBaselineBugs(filterName);
                    continue;
                }
                findBugs.addFilter(filterName, include);
            }
            catch (RuntimeException e) {
                FindbugsPlugin.getDefault().logException(e, "Error while loading filter \"" + filterName + "\".");
            }
            catch (DocumentException e) {
                FindbugsPlugin.getDefault().logException(e, "Error while loading excluded bugs \"" + filterName + "\".");
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Error while reading filter \"" + filterName + "\".");
            }
        }
    }

    public static IPath getFilterPath(String filePath, IProject project) {
        IPath newPath;
        Path path = new Path(filePath);
        if (path.isAbsolute()) {
            return path;
        }
        IPath wspLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (project != null && (newPath = project.getLocation().append((IPath)path)).toFile().exists()) {
            return newPath;
        }
        newPath = wspLocation.append((IPath)path);
        if (newPath.toFile().exists()) {
            return newPath;
        }
        return path;
    }

    public static IPath toFilterPath(String filePath, IProject project) {
        Path path = new Path(filePath);
        IPath commonPath = project != null ? project.getLocation() : ResourcesPlugin.getWorkspace().getRoot().getLocation();
        return FindBugsWorker.getRelativePath((IPath)path, commonPath);
    }

    private static IPath getRelativePath(IPath filePath, IPath commonPath) {
        if (!filePath.isAbsolute()) {
            return filePath;
        }
        int matchingSegments = commonPath.matchingFirstSegments(filePath);
        if (matchingSegments == commonPath.segmentCount()) {
            filePath = filePath.removeFirstSegments(matchingSegments).setDevice(null);
        }
        return filePath;
    }

    private String[] createAuxClasspath() {
        String[] classPath = PDEClassPathGenerator.computeClassPath(this.javaProject);
        return classPath;
    }

    private Map<IPath, IPath> createOutputLocations() throws CoreException {
        HashMap<IPath, IPath> srcToOutputMap = new HashMap<IPath, IPath>();
        IPath defaultOutputLocation = ResourceUtils.relativeToAbsolute(this.javaProject.getOutputLocation());
        IClasspathEntry[] entries = this.javaProject.getResolvedClasspath(true);
        for (int i = 0; i < entries.length; ++i) {
            IClasspathEntry classpathEntry = entries[i];
            if (classpathEntry.getEntryKind() != 3) continue;
            IPath outputLocation = ResourceUtils.getOutputLocation(classpathEntry, defaultOutputLocation);
            IPath srcLocation = ResourceUtils.relativeToAbsolute(classpathEntry.getPath());
            srcToOutputMap.put(srcLocation, outputLocation);
        }
        return srcToOutputMap;
    }

    /*
     * Exception decompiling
     */
    private void reportFromXml(String xmlFileName, Project findBugsProject, Reporter bugReporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

