/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.Reporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtUtils {
    private static boolean is50OrHigher(IJavaElement javaElt) {
        IJavaProject project = javaElt.getJavaProject();
        String option = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        boolean result = "1.5".equals(option);
        if (result) {
            return result;
        }
        result = "1.4".equals(option);
        if (result) {
            return false;
        }
        result = "1.3".equals(option);
        if (result) {
            return false;
        }
        result = "1.2".equals(option);
        if (result) {
            return false;
        }
        result = "1.1".equals(option);
        return !result;
    }

    public static IType findAnonymous(IType parentType, String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return null;
        }
        int anonIndex = Integer.parseInt(name) - 1;
        if (anonIndex < 0) {
            return null;
        }
        ArrayList<IType> list = new ArrayList<IType>();
        boolean allowNested = !JdtUtils.is50OrHigher((IJavaElement)parentType);
        IType declaringType = allowNested ? (IType)JdtUtils.getLastAncestor((IJavaElement)parentType, 7) : parentType.getDeclaringType();
        if (declaringType == null) {
            declaringType = parentType;
        }
        try {
            JdtUtils.collectAllAnonymous(list, (IParent)declaringType, allowNested);
        }
        catch (JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, "collectAllAnonymous() failed");
        }
        if (list.size() <= anonIndex) {
            return null;
        }
        JdtUtils.sortAnonymous(list, parentType);
        return (IType)list.get(anonIndex);
    }

    private static void collectAllAnonymous(List<IType> list, IParent parent, boolean allowNested) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IJavaElement childElem = children[i];
            if (JdtUtils.isAnonymousType(childElem)) {
                list.add((IType)childElem);
            }
            if (!(childElem instanceof IParent) || !allowNested && childElem instanceof IType) continue;
            JdtUtils.collectAllAnonymous(list, (IParent)childElem, allowNested);
        }
    }

    private static void sortAnonymous(List<IType> anonymous, IType anonType) {
        SourceOffsetComparator sourceComparator = new SourceOffsetComparator();
        AnonymClassComparator classComparator = new AnonymClassComparator(anonType, sourceComparator);
        Collections.sort(anonymous, classComparator);
        if (Reporter.DEBUG) {
            JdtUtils.debugCompilePrio(classComparator);
        }
    }

    private static void debugCompilePrio(AnonymClassComparator classComparator) {
        final Map map = classComparator.map;
        Comparator<IType> prioComp = new Comparator<IType>(){

            @Override
            public int compare(IType e1, IType e2) {
                int result = ((Integer)map.get(e1)).compareTo((Integer)map.get(e2));
                if (result == 0) {
                    return e1.toString().compareTo(e2.toString());
                }
                return -result;
            }
        };
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys, prioComp);
        for (Object key : keys) {
            System.out.println(map.get(key) + " : " + key);
        }
    }

    private static int getAnonCompilePriority(IJavaElement elt, IJavaElement firstAncestor, IJavaElement topAncestor, boolean is50OrHigher) {
        if (is50OrHigher) {
            return JdtUtils.getAnonCompilePriority50(elt, firstAncestor, topAncestor);
        }
        IJavaElement firstNonAnon = JdtUtils.getFirstNonAnonymous(elt, topAncestor);
        if (topAncestor != firstNonAnon && JdtUtils.isLocal(firstNonAnon)) {
            return 5;
        }
        IJavaElement initBlock = JdtUtils.getLastAncestor(elt, 10);
        if (initBlock != null) {
            if (JdtUtils.isAnyParentLocal(firstAncestor, topAncestor)) {
                return 5;
            }
            if (firstAncestor == topAncestor) {
                return 10;
            }
            if (!JdtUtils.isStatic((IMember)firstNonAnon)) {
                return 8;
            }
            return 7;
        }
        if (firstNonAnon != topAncestor) {
            if (!JdtUtils.isStatic((IMember)firstNonAnon)) {
                return 7;
            }
            return 6;
        }
        return 5;
    }

    private static int getAnonCompilePriority50(IJavaElement javaElement, IJavaElement firstAncestor, IJavaElement topAncestor) {
        IJavaElement initBlock = JdtUtils.getLastAncestor(javaElement, 10);
        if (initBlock != null) {
            return 10;
        }
        return 5;
    }

    private static IType getFirstAncestor(IJavaElement javaElement) {
        IJavaElement parent = javaElement;
        if (javaElement.getElementType() == 7) {
            parent = javaElement.getParent();
        }
        if (parent != null) {
            return (IType)parent.getAncestor(7);
        }
        return null;
    }

    private static IJavaElement getFirstNonAnonymous(IJavaElement javaElement, IJavaElement topAncestor) {
        if (javaElement.getElementType() == 7 && !JdtUtils.isAnonymousType(javaElement)) {
            return javaElement;
        }
        IJavaElement parent = javaElement.getParent();
        if (parent == null) {
            return topAncestor;
        }
        IJavaElement ancestor = parent.getAncestor(7);
        if (ancestor != null) {
            return JdtUtils.getFirstNonAnonymous(ancestor, topAncestor);
        }
        return topAncestor;
    }

    private static IJavaElement getLastAncestor(IJavaElement javaElement, int elementType) {
        IJavaElement parent;
        IJavaElement lastFound = null;
        if (elementType == javaElement.getElementType()) {
            lastFound = javaElement;
        }
        if ((parent = javaElement.getParent()) == null) {
            return lastFound;
        }
        IJavaElement ancestor = parent.getAncestor(elementType);
        if (ancestor != null) {
            return JdtUtils.getLastAncestor(ancestor, elementType);
        }
        return lastFound;
    }

    private static int getTopAncestorDistance(IJavaElement javaElement, IJavaElement topAncestor) {
        if (topAncestor == javaElement) {
            return 0;
        }
        IType ancestor = JdtUtils.getFirstAncestor(javaElement);
        if (ancestor != null) {
            return 1 + JdtUtils.getTopAncestorDistance((IJavaElement)ancestor, topAncestor);
        }
        return -1;
    }

    private static boolean isAnonymousType(IJavaElement javaElement) {
        try {
            return javaElement instanceof IType && ((IType)javaElement).isAnonymous();
        }
        catch (JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, "isAnonymousType() failed");
            return false;
        }
    }

    private static boolean isFromInitBlock(IType type) {
        IJavaElement ancestor = type.getAncestor(10);
        return ancestor != null;
    }

    private static boolean isLocal(IJavaElement innerType) {
        try {
            return innerType instanceof IType && ((IType)innerType).isLocal();
        }
        catch (JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, "isLocal() failed");
            return false;
        }
    }

    private static boolean isStatic(IMember firstNonAnon) {
        int topFlags = 0;
        try {
            topFlags = firstNonAnon.getFlags();
        }
        catch (JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, "isStatic() failed");
        }
        return Flags.isStatic((int)topFlags);
    }

    private static boolean isAnyParentLocal(IJavaElement elt, IJavaElement topParent) {
        if (JdtUtils.isLocal(elt)) {
            return true;
        }
        for (IJavaElement parent = elt.getParent(); parent != null && parent != topParent; parent = parent.getParent()) {
            if (!JdtUtils.isLocal(parent)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SourceOffsetComparator
    implements Comparator<IType> {
        SourceOffsetComparator() {
        }

        @Override
        public int compare(IType o1, IType o2) {
            int idx2;
            int idx1;
            IType m1 = o1;
            IType m2 = o2;
            try {
                ISourceRange sr1 = m1.getSourceRange();
                ISourceRange sr2 = m2.getSourceRange();
                if (sr1 == null || sr2 == null) {
                    return 0;
                }
                idx1 = sr1.getOffset();
                idx2 = sr2.getOffset();
            }
            catch (JavaModelException e) {
                FindbugsPlugin.getDefault().logException(e, "SourceOffsetComparator failed");
                return 0;
            }
            return idx1 - idx2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnonymClassComparator
    implements Comparator<IType> {
        private final IType topAncestorType;
        private final SourceOffsetComparator sourceComparator;
        private final boolean is50OrHigher;
        private final Map<IType, Integer> map;

        public AnonymClassComparator(IType javaElement, SourceOffsetComparator sourceComparator) {
            this.sourceComparator = sourceComparator;
            this.is50OrHigher = JdtUtils.is50OrHigher((IJavaElement)javaElement);
            this.topAncestorType = (IType)JdtUtils.getLastAncestor((IJavaElement)javaElement, 7);
            this.map = new IdentityHashMap<IType, Integer>();
        }

        private int compare50(IType m1, IType m2) {
            int compilePrio2;
            IType firstAncestor1 = JdtUtils.getFirstAncestor((IJavaElement)m1);
            IType firstAncestor2 = JdtUtils.getFirstAncestor((IJavaElement)m2);
            int compilePrio1 = this.getCompilePrio(m1, (IJavaElement)firstAncestor1);
            if (compilePrio1 > (compilePrio2 = this.getCompilePrio(m2, (IJavaElement)firstAncestor2))) {
                return -1;
            }
            if (compilePrio1 < compilePrio2) {
                return 1;
            }
            return this.sourceComparator.compare(m1, m2);
        }

        @Override
        public int compare(IType m1, IType m2) {
            int topAncestorDistance2;
            boolean isLocal;
            int compilePrio2;
            if (m1 == m2) {
                return 0;
            }
            if (this.is50OrHigher) {
                return this.compare50(m1, m2);
            }
            IType firstAncestor1 = JdtUtils.getFirstAncestor((IJavaElement)m1);
            IType firstAncestor2 = JdtUtils.getFirstAncestor((IJavaElement)m2);
            int compilePrio1 = this.getCompilePrio(m1, (IJavaElement)firstAncestor1);
            if (compilePrio1 > (compilePrio2 = this.getCompilePrio(m2, (IJavaElement)firstAncestor2))) {
                return -1;
            }
            if (compilePrio1 < compilePrio2) {
                return 1;
            }
            firstAncestor1 = JdtUtils.getFirstNonAnonymous((IJavaElement)m1, (IJavaElement)this.topAncestorType);
            if (firstAncestor1 == (firstAncestor2 = JdtUtils.getFirstNonAnonymous((IJavaElement)m2, (IJavaElement)this.topAncestorType))) {
                boolean fromInitBlock2;
                boolean fromInitBlock1;
                if (JdtUtils.isLocal((IJavaElement)firstAncestor1) && (fromInitBlock1 = JdtUtils.isFromInitBlock(m1)) ^ (fromInitBlock2 = JdtUtils.isFromInitBlock(m2))) {
                    return fromInitBlock1 ? -1 : 1;
                }
                return this.sourceComparator.compare(m1, m2);
            }
            boolean bl = isLocal = JdtUtils.isLocal((IJavaElement)firstAncestor1) || JdtUtils.isLocal((IJavaElement)firstAncestor2);
            if (isLocal) {
                return this.sourceComparator.compare(m1, m2);
            }
            int topAncestorDistance1 = JdtUtils.getTopAncestorDistance((IJavaElement)firstAncestor1, (IJavaElement)this.topAncestorType);
            if (topAncestorDistance1 > (topAncestorDistance2 = JdtUtils.getTopAncestorDistance((IJavaElement)firstAncestor2, (IJavaElement)this.topAncestorType))) {
                return -1;
            }
            if (topAncestorDistance1 < topAncestorDistance2) {
                return 1;
            }
            return this.sourceComparator.compare(m1, m2);
        }

        private int getCompilePrio(IType anonType, IJavaElement firstAncestor) {
            int compilePrio;
            Integer prio = this.map.get(anonType);
            if (prio != null) {
                compilePrio = prio;
                if (Reporter.DEBUG) {
                    System.out.println("Using cache");
                }
            } else {
                compilePrio = JdtUtils.getAnonCompilePriority((IJavaElement)anonType, firstAncestor, (IJavaElement)this.topAncestorType, this.is50OrHigher);
                this.map.put(anonType, compilePrio);
                if (Reporter.DEBUG) {
                    System.out.println("Calculating value!");
                }
            }
            return compilePrio;
        }
    }
}

