/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.util.ConfigurableXmlOutputStream;
import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.Footprint;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.log.Profiler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class Reporter
extends AbstractBugReporter
implements FindBugsProgress {
    public static boolean DEBUG;
    private final IJavaProject project;
    private final IProgressMonitor monitor;
    private final SortedBugCollection bugCollection;
    private int pass = -1;
    private int bugCount;
    private IOConsoleOutputStream stream;

    public Reporter(IJavaProject project, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.project = project;
        this.bugCollection = new SortedBugCollection(this.getProjectStats());
    }

    public void setReportingStream(IOConsoleOutputStream stream) {
        this.stream = stream;
    }

    boolean isStreamReportingEnabled() {
        return this.stream != null && !this.stream.isClosed();
    }

    void printToStream(String message) {
        if (this.isStreamReportingEnabled()) {
            try {
                this.stream.write(message);
                this.stream.write("\n");
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Print to console failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReportBug(BugInstance bug) {
        SortedBugCollection sortedBugCollection = this.bugCollection;
        synchronized (sortedBugCollection) {
            if (this.bugCollection.contains(bug)) {
                if (DEBUG) {
                    System.out.println("Duplicated bug added: " + bug);
                }
                return;
            }
            this.bugCollection.add(bug);
        }
        ++this.bugCount;
    }

    public void reportQueuedErrors() {
        Set<String> missingClasses;
        ArrayList<AbstractBugReporter.Error> errorList = new ArrayList<AbstractBugReporter.Error>(this.getQueuedErrors());
        if (errorList.size() > 0) {
            Collections.sort(errorList, new Comparator<AbstractBugReporter.Error>(){

                @Override
                public int compare(AbstractBugReporter.Error o1, AbstractBugReporter.Error o2) {
                    return o1.getSequence() - o2.getSequence();
                }
            });
            MultiStatus status = new MultiStatus("edu.umd.cs.findbugs.plugin.eclipse", 4, "The following errors occurred during FindBugs analysis:", null);
            for (AbstractBugReporter.Error error : errorList) {
                status.add(FindbugsPlugin.createErrorStatus(error.getMessage(), error.getCause()));
            }
            FindbugsPlugin.getDefault().getLog().log((IStatus)status);
        }
        if ((missingClasses = this.getMissingClasses()).size() > 0) {
            MultiStatus status = new MultiStatus("edu.umd.cs.findbugs.plugin.eclipse", 2, "The following classes needed for FindBugs analysis on project " + this.project.getElementName() + " were missing:", null);
            for (String missingClass : missingClasses) {
                status.add((IStatus)new Status(2, "edu.umd.cs.findbugs.plugin.eclipse", missingClass));
            }
            FindbugsPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public void finish() {
        if (DEBUG) {
            System.out.println("Finish: Found " + this.bugCount + " bugs.");
        }
        if (!this.isStreamReportingEnabled()) {
            return;
        }
        this.printToStream("finished, found: " + this.bugCount + " bugs");
        ConfigurableXmlOutputStream xmlStream = new ConfigurableXmlOutputStream((OutputStream)this.stream, true);
        ProjectStats stats = this.bugCollection.getProjectStats();
        this.printToStream(new Footprint(stats.getBaseFootprint()).toString());
        Profiler profiler = stats.getProfiler();
        PrintStream printStream = new PrintStream((OutputStream)this.stream);
        this.printToStream("Total time:");
        profiler.report(new Profiler.TotalTimeComparator(profiler), new Profiler.FilterByTime(10000000L), printStream);
        this.printToStream("Total calls:");
        profiler.report(new Profiler.TotalCallsComparator(profiler), new Profiler.FilterByCalls(stats.getNumClasses()), printStream);
        this.printToStream("Time per call:");
        profiler.report(new Profiler.TimePerCallComparator(profiler), new Profiler.FilterByTimePerCall(10000000 / stats.getNumClasses()), printStream);
        try {
            xmlStream.finish();
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Print to console failed");
        }
    }

    public SortedBugCollection getBugCollection() {
        return this.bugCollection;
    }

    public void observeClass(ClassDescriptor classDescriptor) {
        if (this.monitor.isCanceled()) {
            Thread.currentThread().interrupt();
        }
        int work = this.pass == 0 ? 1 : 2;
        String className = classDescriptor.getDottedClassName();
        if (DEBUG) {
            System.out.println("Observing class: " + className);
        }
        if (this.pass <= 0) {
            this.monitor.setTaskName("Prescanning... (found " + this.bugCount + ", checking " + className + ")");
        } else {
            this.monitor.setTaskName("Checking... (pass #" + this.pass + ") (found " + this.bugCount + ", checking " + className + ")");
        }
        this.monitor.worked(work);
    }

    public void reportAnalysisError(AnalysisError error) {
    }

    public void reportMissingClass(String missingClass) {
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    public void finishArchive() {
    }

    public void finishClass() {
    }

    public void finishPerClassAnalysis() {
    }

    public void reportNumberOfArchives(int numArchives) {
        this.printToStream("archives to analyze: " + numArchives);
    }

    public void startAnalysis(int numClasses) {
        ++this.pass;
        this.printToStream("start pass: " + this.pass + " on " + numClasses + " classes");
    }

    public void predictPassCount(int[] classesPerPass) {
        int expectedWork = 0;
        for (int count : classesPerPass) {
            expectedWork += 2 * count;
        }
        expectedWork -= classesPerPass[0];
        if (!(this.monitor instanceof SubProgressMonitor)) {
            this.monitor.beginTask("Performing bug checking...", expectedWork);
        }
    }

    public void startArchive(String name) {
    }
}

