/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.util;

import de.tobject.findbugs.FindbugsPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectUtilities {
    private static boolean DEBUG;

    public static void addFindBugsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (ProjectUtilities.hasFindBugsNature(project)) {
            return;
        }
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        for (int i = 0; i < prevNatures.length; ++i) {
            if (!prevNatures[i].equals("edu.umd.cs.findbugs.plugin.eclipse.findbugsNature")) continue;
            return;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = "edu.umd.cs.findbugs.plugin.eclipse.findbugsNature";
        if (DEBUG) {
            for (int i = 0; i < newNatures.length; ++i) {
                System.out.println(newNatures[i]);
            }
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static boolean hasFindBugsNature(IProject project) {
        try {
            return ProjectUtilities.isJavaProject(project) && project.hasNature("edu.umd.cs.findbugs.plugin.eclipse.findbugsNature");
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error while testing FindBugs nature for project " + project);
            return false;
        }
    }

    public static void removeFindBugsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!ProjectUtilities.hasFindBugsNature(project)) {
            return;
        }
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNaturesList = new ArrayList<String>();
        for (int i = 0; i < prevNatures.length; ++i) {
            if (prevNatures[i].equals("edu.umd.cs.findbugs.plugin.eclipse.findbugsNature")) continue;
            newNaturesList.add(prevNatures[i]);
        }
        String[] newNatures = newNaturesList.toArray(new String[newNaturesList.size()]);
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "couldn't determine project nature");
            return false;
        }
    }
}

