/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.properties;

import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.properties.PropPageTitleProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BugGroupSection
extends AbstractPropertySection {
    private Composite rootComposite;
    private Text text;
    private final PropPageTitleProvider provider = new PropPageTitleProvider();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Color background = tabbedPropertySheetPage.getWidgetFactory().getColors().getBackground();
        this.rootComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = 5;
        layout.marginTop = 5;
        this.rootComposite.setLayout((Layout)layout);
        this.rootComposite.setSize(-1, -1);
        this.rootComposite.setBackground(background);
        this.text = new Text(this.rootComposite, 72);
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        this.text.setLayoutData((Object)data);
        this.text.setBackground(background);
        this.text.setFont(JFaceResources.getTextFont());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.refreshText(selection);
    }

    public void refresh() {
        super.refresh();
    }

    public void dispose() {
        if (this.rootComposite != null) {
            this.rootComposite.dispose();
        }
        super.dispose();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private void refreshText(ISelection selection) {
        this.text.setText("");
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection2 = (IStructuredSelection)selection;
        if (selection2.size() > 1) {
            String description = this.getSummary(selection2);
            this.text.setText(description);
        } else {
            Object element = selection2.getFirstElement();
            if (!(element instanceof BugGroup)) {
                return;
            }
            BugGroup bugGroup = (BugGroup)element;
            String title = this.provider.getTitle(bugGroup);
            char[] separator = new char[title.length() + 1];
            Arrays.fill(separator, '=');
            separator[0] = 10;
            this.text.setText(title + String.valueOf(separator) + "\nBugs count: " + bugGroup.getMarkersCount());
        }
    }

    private String getSummary(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        HashSet<BugGroup> groups = new HashSet<BugGroup>();
        HashSet<IMarker> markers = new HashSet<IMarker>();
        while (iter.hasNext()) {
            BugGroup group;
            Object object = iter.next();
            if (!(object instanceof BugGroup) || groups.contains(group = (BugGroup)object)) continue;
            markers.addAll(group.getAllMarkers());
            groups.add(group);
        }
        TreeSet<String> names = new TreeSet<String>();
        for (BugGroup bugGroup : groups) {
            String description = bugGroup.getShortDescription() + " (" + bugGroup.getMarkersCount() + ")";
            names.add(description);
        }
        StringBuilder sb = new StringBuilder();
        int maxLength = 0;
        for (String name : names) {
            sb.append(name).append("\n");
            if (name.length() <= maxLength) continue;
            maxLength = name.length();
        }
        char[] separator = new char[maxLength];
        Arrays.fill(separator, '=');
        sb.append(separator);
        String description = sb.toString() + "\nOverall bugs count: " + markers.size();
        return description;
    }
}

