/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

public abstract class FindBugsCommandLine
extends CommandLine {
    protected AnalysisFeatureSetting[] settingList = FindBugs.DEFAULT_EFFORT;
    protected Project project = new Project();
    protected boolean projectLoadedFromFile;

    public FindBugsCommandLine() {
        this.startOptionGroup("General FindBugs options:");
        this.addOption("-project", "project", "analyze given project");
        this.addOption("-home", "home directory", "specify FindBugs home directory");
        this.addOption("-pluginList", "jar1[" + File.pathSeparator + "jar2...]", "specify list of plugin Jar files to load");
        this.addSwitchWithOptionalExtraPart("-effort", "min|less|default|more|max", "set analysis effort level");
        this.addSwitch("-adjustExperimental", "lower priority of experimental Bug Patterns");
        this.addSwitch("-workHard", "ensure analysis effort is at least 'default'");
        this.addSwitch("-conserveSpace", "same as -effort:min (for backward compatibility)");
    }

    public FindBugsCommandLine(boolean modernGui) {
        this();
        this.addOption("-f", "font size", "set font size");
        this.addSwitch("-clear", "clear saved GUI settings and exit");
        this.addOption("-priority", "thread priority", "set analysis thread priority");
        this.addOption("-loadbugs", "saved analysis results", "load bugs from saved analysis results");
        this.makeOptionUnlisted("-loadbugs");
        this.addOption("-loadBugs", "saved analysis results", "load bugs from saved analysis results");
        this.addSwitch("-d", "disable docking");
        this.addSwitch("--nodock", "disable docking");
        this.addSwitchWithOptionalExtraPart("-look", "plastic|gtk|native", "set UI look and feel");
    }

    public AnalysisFeatureSetting[] getSettingList() {
        return this.settingList;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    public boolean isProjectLoadedFromFile() {
        return this.projectLoadedFromFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOption(String option, String optionExtraPart) {
        if (option.equals("-effort")) {
            if (optionExtraPart.equals("min")) {
                this.settingList = FindBugs.MIN_EFFORT;
                return;
            } else if (optionExtraPart.equals("less")) {
                this.settingList = FindBugs.LESS_EFFORT;
                return;
            } else if (optionExtraPart.equals("default")) {
                this.settingList = FindBugs.DEFAULT_EFFORT;
                return;
            } else if (optionExtraPart.equals("more")) {
                this.settingList = FindBugs.MORE_EFFORT;
                return;
            } else {
                if (!optionExtraPart.equals("max")) throw new IllegalArgumentException("-effort:<value> must be one of min,default,more,max");
                this.settingList = FindBugs.MAX_EFFORT;
            }
            return;
        } else if (option.equals("-workHard")) {
            if (this.settingList == FindBugs.MAX_EFFORT) return;
            this.settingList = FindBugs.MORE_EFFORT;
            return;
        } else if (option.equals("-conserveSpace")) {
            this.settingList = FindBugs.MIN_EFFORT;
            return;
        } else {
            if (!option.equals("-adjustExperimental")) throw new IllegalArgumentException("Don't understand option " + option);
            BugInstance.setAdjustExperimental(true);
        }
    }

    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        if (option.equals("-home")) {
            FindBugs.setHome(argument);
        } else if (option.equals("-pluginList")) {
            String pluginListStr = argument;
            ArrayList<URL> pluginList = new ArrayList<URL>();
            StringTokenizer tok = new StringTokenizer(pluginListStr, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                pluginList.add(new File(tok.nextToken()).toURL());
            }
            DetectorFactoryCollection.rawInstance().setPluginList(pluginList.toArray(new URL[pluginList.size()]));
        } else if (option.equals("-project")) {
            this.loadProject(argument);
        } else {
            throw new IllegalStateException();
        }
    }

    public void loadProject(String arg) throws IOException {
        this.project = Project.readProject(arg);
        this.projectLoadedFromFile = true;
    }
}

