/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public abstract class WarningSuppressor
implements Matcher {
    static final boolean DEBUG = SystemProperties.getBoolean("warning.suppressor");
    String bugPattern;

    public WarningSuppressor(String bugPattern) {
        this.bugPattern = bugPattern;
        if (DEBUG) {
            System.out.println("Suppressing " + bugPattern);
        }
    }

    public boolean match(BugInstance bugInstance) {
        if (DEBUG) {
            System.out.println("Checking " + bugInstance);
            System.out.println("    type:" + bugInstance.getType());
            System.out.println(" against: " + this.bugPattern);
        }
        if (!(this.bugPattern == null || bugInstance.getType().startsWith(this.bugPattern) || bugInstance.getBugPattern().getCategory().equalsIgnoreCase(this.bugPattern) || bugInstance.getBugPattern().getAbbrev().equalsIgnoreCase(this.bugPattern))) {
            return false;
        }
        if (DEBUG) {
            System.out.println(" pattern matches");
        }
        return true;
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
    }
}

