/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.console.AbstractQueryPage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.ext.QueryResult;

public class HQLQueryPage
extends AbstractQueryPage {
    private String queryString;
    private QueryResult queryResult;

    public HQLQueryPage(ConsoleConfiguration cfg, String string, QueryInputModel model) {
        super(cfg, model);
        this.queryString = string;
        this.setTabName(this.getQueryString().replace('\n', ' ').replace('\r', ' '));
    }

    @Override
    public List<Object> getList() {
        if (this.queryString == null) {
            return Collections.emptyList();
        }
        if (this.list == null) {
            this.updateQueryResults();
        }
        return this.list;
    }

    private void updateQueryResults() {
        try {
            this.list = new ArrayList();
            this.queryResult = this.getConsoleConfiguration().getHibernateExtension().executeHQLQuery(this.queryString, this.model);
            if (!this.queryResult.hasExceptions()) {
                Iterator<Object> iter = this.queryResult.list().iterator();
                this.queryTime = this.queryResult.getQueryTime();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    this.list.add(element);
                }
                this.pcs.firePropertyChange("list", null, this.list);
            } else {
                for (Throwable e : this.queryResult.getExceptions()) {
                    this.addException(e);
                }
            }
        }
        catch (HibernateException e) {
            this.addException(e);
        }
        catch (IllegalArgumentException e) {
            this.addException(e);
        }
    }

    @Override
    public List<String> getPathNames() {
        try {
            if (this.queryResult == null) {
                this.updateQueryResults();
            }
        }
        catch (HibernateException e) {
            this.addException(e);
        }
        return this.queryResult == null ? Collections.emptyList() : this.queryResult.getPathNames();
    }

    @Override
    public void setSession(Session s) {
    }

    @Override
    public void release() {
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void setQueryString(String queryString) {
        this.queryString = queryString;
        this.list = null;
        this.queryResult = null;
    }
}

