/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Enhancer;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.ClassNode;
import org.hibernate.console.node.ConfigurationEntitiesNode;
import org.hibernate.console.node.IdentifierNode;
import org.hibernate.console.node.PersistentCollectionNode;
import org.hibernate.console.node.PropertyNode;
import org.hibernate.console.node.ProxyFactory;
import org.hibernate.console.node.TableNode;
import org.hibernate.mapping.Table;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class NodeFactory {
    private Map<String, ClassMetadata> classMetaData;
    private List<String> classes;
    private Map<String, CollectionMetadata> collectionMetaData;
    private ConsoleConfiguration consoleConfiguration;

    public NodeFactory(ConsoleConfiguration c) throws HibernateException {
        this.setConsoleConfiguration(c);
    }

    private void setConsoleConfiguration(ConsoleConfiguration c) {
        this.consoleConfiguration = c;
        SessionFactory sf = c.getSessionFactory();
        this.classMetaData = sf.getAllClassMetadata();
        this.collectionMetaData = sf.getAllCollectionMetadata();
        this.classes = new ArrayList<String>();
        this.classes.addAll(this.classMetaData.keySet());
    }

    public ConfigurationEntitiesNode createConfigurationEntitiesNode(String name) {
        Enhancer e = ProxyFactory.createEnhancer(ConfigurationEntitiesNode.class);
        return (ConfigurationEntitiesNode)e.create(new Class[]{String.class, NodeFactory.class, List.class}, new Object[]{name, this, this.classes});
    }

    public BaseNode createObjectNode(Session session, Object o) throws HibernateException {
        ClassMetadata md = this.getMetaData(session.getEntityName(o));
        return this.internalCreateClassNode(null, md.getEntityName(), md, o, false);
    }

    public ClassNode createClassNode(BaseNode node, String clazz) {
        return this.internalCreateClassNode(node, clazz, this.getMetaData(clazz), null, false);
    }

    private ClassNode internalCreateClassNode(BaseNode node, String clazz, ClassMetadata md, Object o, boolean objectGraph) {
        Enhancer e = ProxyFactory.createEnhancer(ClassNode.class);
        return (ClassNode)e.create(new Class[]{NodeFactory.class, BaseNode.class, String.class, ClassMetadata.class, Object.class, Boolean.TYPE}, new Object[]{this, node, clazz, md, o, objectGraph});
    }

    public ClassMetadata getMetaData(String clazz) {
        return this.classMetaData.get(clazz);
    }

    public ClassMetadata getMetaData(Class<?> clazz) {
        return this.getMetaData(clazz.getName());
    }

    public CollectionMetadata getCollectionMetaData(String role) {
        return this.collectionMetaData.get(role);
    }

    public BaseNode createPropertyNode(BaseNode parent, int idx, ClassMetadata metadata) {
        return this.createPropertyNode(parent, idx, metadata, null, false);
    }

    public BaseNode createPropertyNode(BaseNode node, int i, ClassMetadata md, Object baseObject, boolean objectGraph) {
        Enhancer e = ProxyFactory.createEnhancer(PropertyNode.class);
        return (BaseNode)e.create(new Class[]{NodeFactory.class, BaseNode.class, Integer.TYPE, ClassMetadata.class, Object.class, Boolean.TYPE}, new Object[]{this, node, i, md, baseObject, objectGraph});
    }

    public IdentifierNode createIdentifierNode(BaseNode parent, ClassMetadata md) {
        Enhancer e = ProxyFactory.createEnhancer(IdentifierNode.class);
        return (IdentifierNode)e.create(new Class[]{NodeFactory.class, BaseNode.class, ClassMetadata.class}, new Object[]{this, parent, md});
    }

    public BaseNode createNode(BaseNode parent, final Class<?> clazz) {
        ClassMetadata metadata = this.getMetaData(clazz);
        if (metadata != null) {
            return this.createClassNode(parent, clazz.getName());
        }
        return new BaseNode(this, parent){

            @Override
            public String getHQL() {
                return null;
            }

            @Override
            public String getName() {
                return String.valueOf(ConsoleMessages.NodeFactory_unknown) + clazz;
            }

            @Override
            protected void checkChildren() {
            }
        };
    }

    public PersistentCollectionNode createPersistentCollectionNode(ClassNode node, String name, ClassMetadata md, CollectionType type, Object baseObject, boolean objectGraph) {
        Enhancer e = ProxyFactory.createEnhancer(PersistentCollectionNode.class);
        return (PersistentCollectionNode)e.create(new Class[]{NodeFactory.class, BaseNode.class, String.class, CollectionType.class, ClassMetadata.class, CollectionMetadata.class, Object.class, Boolean.TYPE}, new Object[]{this, node, name, type, md, this.getCollectionMetaData(type.getRole()), baseObject, objectGraph});
    }

    public String getIconNameForType(Type type) {
        EntityType et;
        String result = "UNKNOWNPROPERTY";
        result = type.isEntityType() ? (!(et = (EntityType)type).isOneToOne() ? "MANYTOONE" : "ONETOONE") : (type.isAnyType() ? "ANY" : (type.isComponentType() ? "COMPONENT" : (type.isCollectionType() ? "ONETOMANY" : "PROPERTY")));
        return result;
    }

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.consoleConfiguration;
    }

    public static TableNode createTableNode(BaseNode parent, Table table) {
        return new TableNode(parent, table);
    }
}

