/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu.action;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedProperties;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedPropertiesWizard;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.menu.VpeMenuUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.w3c.dom.Node;

public class EditAttributesAction
extends Action {
    final Node node;
    final VpeMenuUtil menuUtil = new VpeMenuUtil();

    public EditAttributesAction() {
        this.node = this.menuUtil.getSelectedNode();
        this.init();
    }

    public EditAttributesAction(Node node) {
        this.node = node;
        this.init();
    }

    private void init() {
        String name = MessageFormat.format(VpeUIMessages.ATTRIBUTES_MENU_ITEM, this.node != null ? this.node.getNodeName() : "");
        this.setText(name);
    }

    public void run() {
        this.showProperties(this.node);
    }

    public boolean isEnabled() {
        VpeElementMapping elementMapping;
        VpeDomMapping domMapping = this.menuUtil.getDomMapping();
        return this.node != null && this.node.getNodeType() == 1 && (elementMapping = (VpeElementMapping)domMapping.getNodeMapping(this.node)) != null && elementMapping.getTemplate() != null;
    }

    private void showProperties(Node node) {
        ExtendedProperties p = EditAttributesAction.createExtendedProperties(node);
        if (p != null) {
            ExtendedPropertiesWizard.run((ExtendedProperties)p);
        }
    }

    public static ExtendedProperties createExtendedProperties(Node node) {
        Class c = ModelFeatureFactory.getInstance().getFeatureClass("org.jboss.tools.jst.jsp.outline.VpeProperties");
        try {
            return (ExtendedProperties)c.getDeclaredConstructor(Node.class).newInstance(node);
        }
        catch (IllegalArgumentException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (SecurityException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InstantiationException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }
}

