/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.template.ISelectionManager;
import org.jboss.tools.vpe.editor.template.SelectionData;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VpeNodesManagingUtil;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISelection;
import org.w3c.dom.Node;

public class SelectionManager
implements ISelectionManager {
    public static boolean updateSelectionEventFlag = false;
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private VpeSelectionController selectionController;

    public SelectionManager(VpePageContext pageContext, StructuredTextEditor sourceEditor, VpeSelectionController selectionController) {
        this.pageContext = pageContext;
        this.sourceEditor = sourceEditor;
        this.selectionController = selectionController;
    }

    @Override
    public boolean isUpdateSelectionEventPerformed() {
        return updateSelectionEventFlag;
    }

    @Override
    public void setUpdateSelectionEventFlag(boolean isPerforming) {
        updateSelectionEventFlag = isPerforming;
    }

    @Override
    public final void setSelection(nsIDOMNode visualNode, int focusOffset, int anchorOffset) {
        int selectionLength;
        int selectionOffset;
        this.setUpdateSelectionEventFlag(true);
        if (visualNode == null) {
            return;
        }
        SelectionData selectionData = this.getSelectionData(visualNode);
        if (selectionData == null) {
            return;
        }
        if (selectionData.getVisualNode().getNodeType() != 3 && SelectionUtil.getSelectedNode(this.getPageContext()) == selectionData.getVisualNode()) {
            return;
        }
        if (selectionData.isNodeEditable()) {
            Point sourceSelectionRange = SelectionUtil.getSourceSelectionRange(visualNode, focusOffset, anchorOffset, selectionData.getSourceNode());
            selectionOffset = sourceSelectionRange.x;
            selectionLength = sourceSelectionRange.y;
        } else {
            selectionOffset = 0;
            selectionLength = NodesManagingUtil.getNodeLength((Node)selectionData.getSourceNode());
        }
        SelectionUtil.setSourceSelection(this.getPageContext(), selectionData.getSourceNode(), selectionOffset, selectionLength);
        this.refreshVisualNodeSelection();
        this.setUpdateSelectionEventFlag(false);
    }

    private SelectionData getSelectionData(nsIDOMNode visualNode) {
        boolean isNodeEditable;
        Node targetSourceNode;
        nsIDOMNode targetVisualNode;
        VpeNodeMapping nodeMapping = VpeNodesManagingUtil.getNodeMapping(this.getDomMapping(), visualNode);
        if (nodeMapping == null) {
            return null;
        }
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            NodeData nodeData = elementMapping.getTemplate().getNodeData(visualNode, elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                targetVisualNode = nodeData.getVisualNode();
                if (nodeData.getSourceNode() != null) {
                    targetSourceNode = nodeData.getSourceNode();
                    isNodeEditable = nodeData.isEditable();
                } else {
                    targetSourceNode = elementMapping.getSourceNode();
                    isNodeEditable = false;
                }
            } else {
                targetVisualNode = elementMapping.getVisualNode();
                targetSourceNode = elementMapping.getSourceNode();
                isNodeEditable = false;
            }
        } else {
            targetVisualNode = nodeMapping.getVisualNode();
            targetSourceNode = nodeMapping.getSourceNode();
            isNodeEditable = true;
        }
        SelectionData selectionData = new SelectionData(targetVisualNode, targetSourceNode, isNodeEditable);
        return selectionData;
    }

    @Override
    public final void refreshVisualSelection() {
        this.setUpdateSelectionEventFlag(true);
        this.refreshVisualNodeSelection();
        this.refreshVisualTextSelection();
    }

    private void refreshVisualNodeSelection() {
        if (this.getSourceEditor().getTextViewer() == null) {
            return;
        }
        Point range = SelectionUtil.getSourceSelectionRange(this.getSourceEditor());
        if (range == null) {
            return;
        }
        List<VpeNodeMapping> nodeMappings = SelectionUtil.getNodeMappingsBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (nodeMappings == null) {
            return;
        }
        ArrayList<nsIDOMNode> targetVisualNodes = new ArrayList<nsIDOMNode>();
        for (VpeNodeMapping nodeMapping : nodeMappings) {
            if (nodeMapping instanceof VpeElementMapping) {
                VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
                targetVisualNodes.add(elementMapping.getTemplate().getVisualNodeBySourcePosition(elementMapping, range, this.getDomMapping()));
                continue;
            }
            targetVisualNodes.add(nodeMapping.getVisualNode());
        }
        this.getPageContext().getVisualBuilder().setSelectionRectangle(targetVisualNodes);
    }

    private void refreshVisualTextSelection() {
        if (this.getSourceEditor().getTextViewer() == null) {
            return;
        }
        Point range = SelectionUtil.getSourceSelectionRange(this.getSourceEditor());
        if (range == null) {
            return;
        }
        VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (nodeMapping == null) {
            return;
        }
        SelectionUtil.clearSelection(this.selectionController);
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            nsIDOMNode targetVisualNode = elementMapping.getTemplate().getVisualNodeBySourcePosition(elementMapping, range, this.getDomMapping());
            NodeData nodeData = elementMapping.getTemplate().getNodeData(targetVisualNode, elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                this.restoreVisualCursorPosition(elementMapping.getTemplate(), nodeData, range);
            }
        }
    }

    private void restoreVisualCursorPosition(VpeTemplate template, NodeData nodeData, Point selectionRange) {
        nsIDOMNode visualNode = nodeData.getVisualNode();
        if (visualNode != null && visualNode.getNodeType() == 3 && nodeData.getSourceNode() != null) {
            Node targetSourceNode = nodeData.getSourceNode();
            int focusOffcetReferenceToSourceNode = selectionRange.x - NodesManagingUtil.getStartOffsetNode((Node)targetSourceNode);
            int anchorOffcetReferenceToSourceNode = selectionRange.x + selectionRange.y - NodesManagingUtil.getStartOffsetNode((Node)targetSourceNode);
            int length = visualNode.getNodeValue().length();
            NodeImpl sourceTextImpl = (NodeImpl)targetSourceNode;
            int visualNodeFocusOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), focusOffcetReferenceToSourceNode);
            int visualNodeAnchorOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), anchorOffcetReferenceToSourceNode);
            if (visualNodeFocusOffcet > length || visualNodeAnchorOffcet > length) {
                return;
            }
            nsISelection selection = this.selectionController.getSelection((short)1);
            selection.collapse(visualNode, visualNodeFocusOffcet);
            if (visualNodeAnchorOffcet != visualNodeFocusOffcet) {
                selection.extend(visualNode, visualNodeAnchorOffcet);
            }
        }
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected VpeDomMapping getDomMapping() {
        return this.pageContext.getDomMapping();
    }

    protected StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }
}

