/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.vpe.editor.template.VpeCreator;

public class VpeDependencyMap {
    private Map dependencyMap = new HashMap();
    private boolean caseSensitive;

    VpeDependencyMap(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    VpeCreator[] getCreators(String signature) {
        DependencyArray creators;
        if (this.dependencyMap == null) {
            return new VpeCreator[0];
        }
        if (!this.caseSensitive) {
            signature = signature.toLowerCase();
        }
        if ((creators = (DependencyArray)this.dependencyMap.get(signature)) == null) {
            return new VpeCreator[0];
        }
        return creators.creators;
    }

    boolean contains(String signature) {
        if (this.dependencyMap == null) {
            return false;
        }
        if (!this.caseSensitive) {
            signature = signature.toLowerCase();
        }
        return this.dependencyMap.get(signature) != null;
    }

    void setCreator(VpeCreator creator, Set signatureSet) {
        if (signatureSet != null) {
            Iterator iter = signatureSet.iterator();
            while (iter.hasNext()) {
                this.setCreator(creator, (String)iter.next());
            }
        }
    }

    void setCreator(VpeCreator creator, String signature) {
        HashSet<VpeCreator> creatorSet;
        if (!this.caseSensitive) {
            signature = signature.toLowerCase();
        }
        if ((creatorSet = (HashSet<VpeCreator>)this.dependencyMap.get(signature)) == null) {
            creatorSet = new HashSet<VpeCreator>();
            this.dependencyMap.put(signature, creatorSet);
        }
        creatorSet.add(creator);
    }

    void validate() {
        if (this.dependencyMap.isEmpty()) {
            this.dependencyMap = null;
            return;
        }
        Set entrySet = this.dependencyMap.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Set creatorSet = (Set)entry.getValue();
            if (creatorSet.isEmpty()) {
                iter.remove();
                continue;
            }
            VpeCreator[] creatorArray = creatorSet.toArray(new VpeCreator[creatorSet.size()]);
            entry.setValue(new DependencyArray(creatorArray));
        }
    }

    private static class DependencyArray {
        private VpeCreator[] creators;

        private DependencyArray(VpeCreator[] creators) {
            this.creators = creators;
        }
    }
}

