/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import org.eclipse.swt.widgets.Event;
import org.jboss.tools.vpe.editor.template.textformating.FormatData;
import org.jboss.tools.vpe.editor.template.textformating.TextFormatingData;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.IFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.handler.IFormatHandler;

public abstract class FormatController
implements IFormatController {
    protected FormatControllerManager manager;

    public FormatController(FormatControllerManager manager) {
        this.manager = manager;
        manager.addFormatController(this);
    }

    public FormatControllerManager getManager() {
        return this.manager;
    }

    public void handleEvent(Event event) {
        this.manager.setControllerNotifedSelectionChange(true);
        this.run();
        this.manager.getVpeController().sourceSelectionToVisualSelection(true);
        this.manager.setControllerNotifedSelectionChange(false);
    }

    @Override
    public void run() {
        TextFormatingData data = this.manager.getFormatTemplateForSelectedNode();
        if (data == null) {
            return;
        }
        FormatData[] formats = data.getFormatDatas(this.getType());
        int i = 0;
        while (i < formats.length) {
            IFormatHandler handler = this.manager.getHandlerFactory().createHandler(formats[i]);
            if (handler != null && handler.formatIsAllowable()) {
                handler.run(formats[i]);
                return;
            }
            if (this.formatIsAllowable(formats[i])) {
                this.run(formats[i]);
                return;
            }
            ++i;
        }
    }

    protected abstract void run(FormatData var1);

    protected abstract boolean formatIsAllowable(FormatData var1);
}

