/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.util.FaceletUtil;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocTypeUtil {
    private static final String TEMP_FILE_NAME = "VPE-Temporally-";
    private static List<String> urlTags = new ArrayList<String>();
    private static List<String> urlAttributes;

    static {
        urlTags.add("link");
        urlAttributes = new ArrayList<String>();
        urlAttributes.add("href");
    }

    public static String getDoctype(IEditorInput editorInput) {
        String doctype = "";
        if (editorInput instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)editorInput).getFile();
            if (f != null && f.exists()) {
                doctype = DocTypeUtil.getDoctype(f, null);
            }
        } else if (editorInput instanceof ILocationProvider) {
            IPath path = ((ILocationProvider)editorInput).getPath((Object)editorInput);
            if (path != null && path.segmentCount() > 0) {
                doctype = DocTypeUtil.getDoctype(path.toFile());
            }
        } else if (editorInput instanceof IStorageEditorInput) {
            IStorageEditorInput input = (IStorageEditorInput)editorInput;
            IStorage storage = null;
            try {
                storage = input.getStorage();
            }
            catch (CoreException ex) {
                VpePlugin.getPluginLog().logError((Throwable)ex);
            }
            JarEntryFile jarFile = null;
            IFile iFile = null;
            if (storage instanceof JarEntryFile) {
                jarFile = (JarEntryFile)storage;
                try {
                    InputStream is = jarFile.getContents();
                    IJavaProject javaProject = jarFile.getPackageFragmentRoot().getJavaProject();
                    if (javaProject != null) {
                        IProject project = javaProject.getProject();
                        iFile = project.getFile(TEMP_FILE_NAME + jarFile.getFullPath().lastSegment());
                        if (iFile != null && iFile.exists()) {
                            iFile.delete(true, false, null);
                        }
                        iFile.create(is, true, null);
                        doctype = DocTypeUtil.getDoctype(iFile, null);
                        if (iFile != null) {
                            iFile.delete(true, false, null);
                        }
                    }
                }
                catch (CoreException e) {
                    VpePlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }
        return doctype;
    }

    private static String getDoctype(IFile file, List<IFile> previousFiles) {
        String docTypeValue = "";
        Document document = null;
        try {
            document = VpeCreatorUtil.getDocumentForRead(file);
            if (document != null) {
                Element componentElement = FaceletUtil.findComponentElement(document.getDocumentElement());
                if (componentElement != null && "composition".equals(componentElement.getLocalName()) && componentElement.hasAttribute("template")) {
                    String fileName;
                    IFile templateFile;
                    Attr attr = componentElement.getAttributeNode("template");
                    if (attr.getNodeValue().trim().length() > 0 && (templateFile = FileUtil.getFile(fileName = attr.getNodeValue().trim(), file)) != null) {
                        if (previousFiles == null) {
                            previousFiles = new ArrayList<IFile>();
                        }
                        if (!previousFiles.contains(templateFile)) {
                            previousFiles.add(templateFile);
                            docTypeValue = DocTypeUtil.getDoctype(templateFile, previousFiles);
                        }
                    }
                } else {
                    IDOMDocumentType documentType = (IDOMDocumentType)document.getDoctype();
                    if (documentType != null) {
                        docTypeValue = documentType.getSource();
                    }
                }
            }
        }
        finally {
            if (document != null) {
                VpeCreatorUtil.releaseDocumentFromRead(document);
            }
        }
        return docTypeValue != null ? docTypeValue.trim() : "";
    }

    private static String getDoctype(File file) {
        String docTypeValue = "";
        IDOMModel domModel = null;
        try {
            domModel = DocTypeUtil.getModelForRead(file);
            if (domModel != null && domModel.getDocument() != null) {
                IDOMDocument document = domModel.getDocument();
                Element componentElement = FaceletUtil.findComponentElement(document.getDocumentElement());
                if (componentElement != null && "composition".equals(componentElement.getLocalName()) && componentElement.hasAttribute("template")) {
                    Attr attr = componentElement.getAttributeNode("template");
                    if (attr.getNodeValue().trim().length() > 0) {
                        String fileName = attr.getNodeValue().trim();
                        File templateFile = new File(file.getParent(), fileName);
                        if (templateFile.exists()) {
                            docTypeValue = DocTypeUtil.getDoctype(templateFile);
                        }
                    }
                } else {
                    IDOMDocumentType documentType = (IDOMDocumentType)document.getDoctype();
                    if (documentType != null) {
                        docTypeValue = documentType.getSource();
                    }
                }
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
        return docTypeValue != null ? docTypeValue.trim() : "";
    }

    private static IDOMModel getModelForRead(File file) {
        IDOMModel model = null;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        Path location = new Path(file.getAbsolutePath());
        try {
            IDocument bufferDocument;
            bufferManager.connect((IPath)location, LocationKind.LOCATION, (IProgressMonitor)new NullProgressMonitor());
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer((IPath)location, LocationKind.LOCATION);
            if (buffer != null && (bufferDocument = buffer.getDocument()) instanceof IStructuredDocument) {
                model = (IDOMModel)ModelManagerImpl.getInstance().getModelForRead((IStructuredDocument)bufferDocument);
            }
            bufferManager.disconnect((IPath)location, LocationKind.LOCATION, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        return model;
    }

    public static String prepareInitFile(File initFile, IEditorInput editorInput) {
        return String.valueOf(DocTypeUtil.getDoctype(editorInput)) + DocTypeUtil.getContentInitFile(initFile);
    }

    public static String getContentInitFile(File initFile) {
        String result = "";
        try {
            BufferedReader inReader = new BufferedReader(new FileReader(initFile));
            try {
                inReader = new BufferedReader(new FileReader(initFile));
                String line = null;
                while ((line = inReader.readLine()) != null) {
                    if (line != null && line.contains("EditorOverride.css")) {
                        line = line.replace("EditorOverride.css", "file://" + initFile.getParent() + File.separator + "EditorOverride.css");
                    }
                    result = String.valueOf(result) + line;
                }
            }
            finally {
                inReader.close();
            }
        }
        catch (IOException e) {
            VpePlugin.reportProblem(e);
        }
        return result;
    }
}

