/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeNodesManagingUtil {
    private static final String VIEW_TAGNAME = "view";
    private static final String LOCALE_ATTRNAME = "locale";

    public static VpeNodeMapping getNodeMapping(VpeDomMapping domMapping, nsIDOMNode node) {
        return domMapping.getNearNodeMappingAtVisualNode(node);
    }

    public static VpeNodeMapping getNodeMapping(VpeDomMapping domMapping, Node node) {
        return domMapping.getNearNodeMappingAtSourceNode(node);
    }

    public static String getPageLocale(VpePageContext pageContext, Node sourceNode) {
        while (sourceNode != null) {
            if (VIEW_TAGNAME.equals(sourceNode.getLocalName())) break;
            sourceNode = sourceNode.getParentNode();
        }
        if (sourceNode == null || !(sourceNode instanceof Element) || !((Element)sourceNode).hasAttribute(LOCALE_ATTRNAME)) {
            return null;
        }
        String locale = ((Element)sourceNode).getAttribute(LOCALE_ATTRNAME);
        return locale;
    }

    public static String getSourceText(VpePageContext pageContext, int startPosition, int endPosition) {
        return pageContext.getSourceBuilder().getStructuredTextViewer().getTextWidget().getText(startPosition, endPosition);
    }
}

