/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionNotifier
implements ISelectionProvider,
ISelectionChangedListener,
IPostSelectionProvider {
    private ArrayList<ISelectionChangedListener> listeners = new ArrayList(3);
    private ArrayList<ISelectionChangedListener> fires = new ArrayList(3);
    private SelectionChangedEvent event;
    private ISelection selection;

    public void selectionChanged(SelectionChangedEvent event) {
        if (event == null && this.event == null) {
            return;
        }
        if (event != null && this.event != null && (event == this.event || event.equals(this.event))) {
            return;
        }
        this.event = event;
        this.selection = event != null ? event.getSelection() : null;
        this.fireSelectionChanged();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        this.fireSelectionChanged();
    }

    protected void fireSelectionChanged() {
        this.fires.addAll(this.listeners);
        if (this.fires.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.fires.size()) {
            this.fires.get(i).selectionChanged(this.event);
            ++i;
        }
        this.fires.clear();
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
    }
}

