/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.common.model.ui.IStructuredChangeListener;
import org.jboss.tools.common.model.ui.StructuredChangedEvent;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.ColumnDescription;
import org.jboss.tools.common.model.ui.attribute.adapter.ITableAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableStructuredAdapter
implements IAdaptable,
ITableAdapter,
ISelectionChangedListener,
ISelectionProvider {
    private IActionProvider actionProvider;
    private List<ColumnDescription> columnsDescription = new ArrayList<ColumnDescription>();
    private ArrayList<IStructuredChangeListener> structureChangeListener = new ArrayList();
    private ITableLabelProvider tableLabelProvider = new DefaultTableLabelProvider();
    private Object[] value;
    private Object selectedObject;
    private ArrayList<ISelectionChangedListener> selectionChangeListener = new ArrayList();
    private ISelection selection;

    public Object getAdapter(Class adapter) {
        if (adapter == IActionProvider.class) {
            return this.getActionProvider();
        }
        if (adapter == ITableAdapter.class) {
            return this;
        }
        if (adapter == ISelectionProvider.class) {
            return this;
        }
        return null;
    }

    @Override
    public TableColumn[] createTableColumn(Table table, int style) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        Iterator<ColumnDescription> i = this.getColumnsDescription().iterator();
        TableLayout layout = new TableLayout();
        while (i.hasNext()) {
            ColumnDescription description = i.next();
            TableColumn column = new TableColumn(table, description.getStyle());
            column.setText(description.getName());
            column.setData(description.getData());
            column.setImage(description.getImage());
            ColumnWeightData layoutData = new ColumnWeightData(description.getWidth(), description.isResizeable());
            layout.addColumnData((ColumnLayoutData)layoutData);
            columns.add(column);
        }
        table.setLayout((Layout)layout);
        return columns.toArray(new TableColumn[columns.size()]);
    }

    @Override
    public void addStructureChangeListener(IStructuredChangeListener listener) {
        this.structureChangeListener.add(listener);
    }

    @Override
    public void removeStructureChangeListener(IStructuredChangeListener listener) {
        this.structureChangeListener.remove(listener);
    }

    protected void fireStructureChange() {
        ArrayList<IStructuredChangeListener> copy = new ArrayList<IStructuredChangeListener>();
        copy.addAll(this.structureChangeListener);
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            ((IStructuredChangeListener)i.next()).structureChanged(new StructuredChangedEvent(this));
        }
        copy.clear();
    }

    @Override
    public ITableLabelProvider getTableLabelProvider() {
        return this.tableLabelProvider;
    }

    @Override
    public void setTableLabelProvider(ITableLabelProvider tableLabelProvider) {
        this.tableLabelProvider = tableLabelProvider;
    }

    public Object[] getElements(Object inputElement) {
        if (this.value == null) {
            return new Object[0];
        }
        return this.value;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            Object object;
            StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
            this.selectedObject = object = structuredSelection.getFirstElement();
        }
        this.fireSelectionChange();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListener.add(listener);
    }

    public ISelection getSelection() {
        this.selection = this.selectedObject == null ? new StructuredSelection() : new StructuredSelection(new Object[]{this.selectedObject});
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListener.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected void fireSelectionChange() {
        ArrayList<ISelectionChangedListener> copy = new ArrayList<ISelectionChangedListener>(this.selectionChangeListener);
        Iterator<ISelectionChangedListener> i = copy.iterator();
        while (i.hasNext()) {
            i.next().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
        copy.clear();
    }

    @Override
    public IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public void setActionProvider(IActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public List<ColumnDescription> getColumnsDescription() {
        return this.columnsDescription;
    }

    public void addColumnDescription(ColumnDescription description) {
        this.getColumnsDescription().add(description);
    }

    public Object[] getValue() {
        return this.value;
    }

    public void setValue(Object[] value) {
        if (this.value != value) {
            this.selectedObject = null;
            if (this.actionProvider != null) {
                this.actionProvider.update(this.getSelection());
            }
        }
        this.value = value;
        this.fireStructureChange();
    }

    class DefaultTableLabelProvider
    implements ITableLabelProvider {
        DefaultTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return Boolean.TRUE;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

