/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.CheckListAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.wizards.query.list.TreeItemSelectionManager;

public class CheckListFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    protected IContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    private String stringValue;
    private TreeViewer viewer;
    String separator = ";";
    int lock = 0;

    public CheckListFieldEditor() {
    }

    public CheckListFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    protected void adjustForNumColumns(int numColumns) {
        Control control = this.getLabelComposite();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.viewer.getControl().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Control control = this.getLabelComposite(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.verticalAlignment = 1024;
        control.setLayoutData((Object)gd);
        this.getListControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getListControl(parent)};
    }

    private Control getListControl(Composite parent) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            return this.viewer.getControl();
        }
        this.viewer = new TreeViewer(parent, 32);
        this.viewer.setContentProvider(this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)this.contentProvider);
        new TreeItemSelectionManager(this.viewer, new Flipper());
        return this.viewer.getControl();
    }

    protected void init() {
        this.stringValue = this.valueProvider.getStringValue(true);
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
    }

    public void dispose() {
        super.dispose();
        if (this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.getTree().dispose();
        }
        this.viewer = null;
        this.propertyEditor = null;
        this.valueChangeListener = null;
        this.valueProvider = null;
        this.contentProvider = null;
        this.labelProvider = null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateErrorState();
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            this.contentProvider = (IContentProvider)propertyEditor.getAdapter(ITreeContentProvider.class);
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
            this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
            if (propertyEditor.getInput() instanceof CheckListAdapter) {
                this.separator = "" + ((CheckListAdapter)propertyEditor.getInput()).getSeparator();
            }
        }
        this.init();
    }

    public void propertyChange(java.beans.PropertyChangeEvent event) {
        super.propertyChange(event);
        this.valueProvider.removeValueChangeListener(this);
        if ("IPropertyEditor.value".equals(event.getPropertyName())) {
            String s;
            Object v = event.getNewValue();
            String string = s = v == null ? "" : v.toString();
            if (!s.equals(this.stringValue)) {
                this.stringValue = s;
                if (this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed()) {
                    if (this.lock == 0) {
                        ++this.lock;
                        Tree tree = this.viewer.getTree();
                        TreeItem[] is = tree.getItems();
                        HashSet<String> vs = new HashSet<String>();
                        StringTokenizer values = new StringTokenizer(this.stringValue, ";,");
                        while (values.hasMoreTokens()) {
                            String n = values.nextToken();
                            vs.add(n);
                        }
                        int i = 0;
                        while (i < is.length) {
                            Object d = is[i].getData();
                            is[i].setChecked(vs.contains(d));
                            ++i;
                        }
                        --this.lock;
                    }
                    this.viewer.refresh();
                }
            }
        }
        this.valueProvider.addValueChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    void flip0(TreeItem item) {
        if (item == null) {
            return;
        }
        String currentItem = item.getData().toString();
        StringTokenizer values = new StringTokenizer(this.valueProvider.getStringValue(true), ";,");
        String newValue = "";
        boolean currentItemExists = false;
        while (values.hasMoreTokens()) {
            String value = values.nextToken();
            if (value.equals(currentItem)) {
                currentItemExists = true;
                continue;
            }
            if (newValue.length() > 0 && !newValue.endsWith(";") && !newValue.endsWith(",")) {
                newValue = String.valueOf(newValue) + this.separator;
            }
            newValue = String.valueOf(newValue) + value;
        }
        if (!currentItemExists) {
            if (newValue.length() > 0 && !newValue.endsWith(";") && !newValue.endsWith(",")) {
                newValue = String.valueOf(newValue) + this.separator;
            }
            newValue = String.valueOf(newValue) + currentItem;
        }
        this.valueChanged(newValue);
        this.viewer.refresh((Object)currentItem);
    }

    protected void valueChanged(String newValue) {
        String oldValue = this.stringValue;
        this.stringValue = newValue;
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
        this.valueChangeListener.valueChange(event);
    }

    public void setFocus() {
        if (this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.getTree().setFocus();
        }
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void delete() {
    }

    class Flipper
    implements TreeItemSelectionManager.Listener {
        Flipper() {
        }

        public void flip(TreeItem item) {
            if (CheckListFieldEditor.this.lock > 0) {
                return;
            }
            ++CheckListFieldEditor.this.lock;
            CheckListFieldEditor.this.flip0(item);
            --CheckListFieldEditor.this.lock;
        }

        public boolean isSelected(Object data) {
            StringTokenizer values = new StringTokenizer(CheckListFieldEditor.this.valueProvider.getStringValue(true), ";,");
            while (values.hasMoreTokens()) {
                String n = values.nextToken();
                if (data == null || !data.equals(n)) continue;
                return true;
            }
            return false;
        }
    }
}

