/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditorListener;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorEvent;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public abstract class PropertyEditor
implements IPropertyEditor,
PropertyChangeListener {
    protected boolean lineEditor = false;
    protected String labelText;
    protected ICellEditorListener cellEditorListener;
    protected IPropertyChangeListener propertyChangeListener;
    protected IWidgetSettings settings;
    private ArrayList<IPropertyEditorListener> listeners = new ArrayList();
    protected Object input;

    public PropertyEditor() {
    }

    public PropertyEditor(IWidgetSettings settings) {
        this.settings = settings;
    }

    protected abstract CellEditor createCellEditor(Composite var1);

    protected abstract ExtendedFieldEditor createFieldEditor(Composite var1);

    public boolean isLineEditor() {
        return this.lineEditor;
    }

    public boolean isGreedyEditor() {
        return false;
    }

    public boolean callsExternal() {
        return false;
    }

    public Object callExternal(Shell shell) {
        return this.getValue();
    }

    public CellEditor getCellEditor(Composite parent) {
        return this.createCellEditor(parent);
    }

    public ExtendedFieldEditor getFieldEditor(Composite parent) {
        ExtendedFieldEditor fieldEditor = this.createFieldEditor(parent);
        fieldEditor.setLabelText(this.getLabelText());
        return fieldEditor;
    }

    public void setLabelText(String labelText) {
        if (labelText != null) {
            this.labelText = labelText;
        }
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void addPropertyEditorListener(IPropertyEditorListener l) {
        this.listeners.add(l);
    }

    public void removePropertyEditorListener(IPropertyEditorListener l) {
        this.listeners.remove(l);
    }

    public void fireInputChanged() {
        ArrayList list = (ArrayList)this.listeners.clone();
        int i = 0;
        while (i < list.size()) {
            ((IPropertyEditorListener)list.get(i)).inputChangedEvent(new PropertyEditorEvent(this));
            ++i;
        }
        list.clear();
        list = null;
    }

    public void fireValueChanged() {
        ArrayList list = (ArrayList)this.listeners.clone();
        int i = 0;
        while (i < list.size()) {
            ((IPropertyEditorListener)list.get(i)).valueChangedEvent(new PropertyEditorEvent(this));
            ++i;
        }
        list.clear();
        list = null;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        this.input = input;
        this.fireInputChanged();
    }

    public Object getAdapter(Class adapter) {
        Object object = ((IAdaptable)this.getInput()).getAdapter(adapter);
        return object;
    }

    public String getAttributeName() {
        if (this.input instanceof IModelPropertyEditorAdapter && ((IModelPropertyEditorAdapter)this.input).getAttribute() != null) {
            return ((IModelPropertyEditorAdapter)this.input).getAttribute().getName();
        }
        return this.labelText;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setValue(evt.getNewValue());
    }

    public IWidgetSettings getSettings() {
        return this.settings;
    }

    public void setSettings(IWidgetSettings settings) {
        this.settings = settings;
    }

    public String getChangeButtonName() {
        return null;
    }

    public void dispose() {
        this.cellEditorListener = null;
        this.propertyChangeListener = null;
        this.settings = null;
    }
}

