/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.objecteditor;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.objecteditor.XAttributeInfo;
import org.jboss.tools.common.model.ui.objecteditor.XCellEditor;
import org.jboss.tools.common.model.ui.objecteditor.XCellModifier;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class XModelObjectEditor {
    static Color DEFAULT_COLOR = Display.getDefault().getSystemColor(2);
    static Color DISABLED_COLOR = Display.getDefault().getSystemColor(15);
    static Image EMPTY = EclipseResourceUtil.getImage((String)"images/actions/empty.gif");
    protected XTable xtable = new XTable();
    protected XModelObject object = null;
    protected XAttribute[] attributes = new XAttribute[0];
    protected XCellModifier modifier = new XCellModifier();
    protected boolean viewMode = false;
    long updateTimeStamp = -1L;

    public XModelObjectEditor() {
        this.xtable.setTableProvider(new XTableProviderImpl());
    }

    public void dispose() {
        if (this.xtable != null) {
            this.xtable.dispose();
        }
        this.xtable = null;
    }

    public void setModelObject(XModelObject object) {
        if (this.object == object) {
            return;
        }
        this.stopEditing();
        this.object = object;
        if (this.xtable.getTable() == null || this.xtable.getTable().isDisposed()) {
            return;
        }
        this.xtable.getTable().setSelection(-1);
        this.updateTimeStamp = -2L;
        this.update();
    }

    public void setViewMode(boolean b) {
        this.viewMode = b;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, this.xtable.style);
    }

    public Control createControl(Composite parent, int style) {
        this.updateTimeStamp = -1L;
        this.xtable.createControl(parent, style);
        this.xtable.getViewer().setColumnProperties(new String[]{"name", "value"});
        this.xtable.getViewer().setCellModifier((ICellModifier)this.modifier);
        if (!this.viewMode) {
            CellEditor[] cellEditorArray = new CellEditor[2];
            cellEditorArray[1] = new XCellEditor((Composite)this.xtable.getTable());
            this.xtable.getViewer().setCellEditors(cellEditorArray);
        }
        this.update();
        return this.xtable.getTable();
    }

    public Control getControl() {
        return this.xtable.getTable();
    }

    protected void loadAttributes() {
        ArrayList<XAttribute> list = new ArrayList<XAttribute>();
        XAttribute[] as = this.object == null ? new XAttribute[]{} : this.object.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            if (as[i].isVisible()) {
                list.add(as[i]);
            }
            ++i;
        }
        this.attributes = list.toArray(new XAttribute[0]);
    }

    public void stopEditing() {
        CellEditor editor;
        if (this.object != null && this.xtable.getViewer() != null && this.xtable.getViewer().isCellEditorActive() && (editor = this.xtable.getViewer().getCellEditors()[1]) instanceof XCellEditor) {
            ((XCellEditor)editor).applyEditorValue();
        }
    }

    public void update() {
        long ts;
        if (this.xtable.getTable() == null) {
            return;
        }
        long l = ts = this.object == null ? -1L : this.object.getTimeStamp();
        if (this.updateTimeStamp == ts) {
            return;
        }
        this.updateTimeStamp = ts;
        this.loadAttributes();
        this.xtable.update();
    }

    class XTableProviderImpl
    implements XTableProvider {
        XTableProviderImpl() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return XModelObjectEditor.this.attributes.length;
        }

        public String getColumnName(int c) {
            return c == 0 ? "name" : "value";
        }

        public String getValueAt(int r, int c) {
            if (c == 0) {
                String labelText = WizardKeys.getAttributeDisplayName((XAttribute)XModelObjectEditor.this.attributes[r], (boolean)true);
                if (labelText == null) {
                    labelText = XModelObjectEditor.this.attributes[r].getName();
                }
                return labelText;
            }
            String v = XModelObjectEditor.this.object.getAttributeValue(XModelObjectEditor.this.attributes[r].getName());
            if (XModelObjectEditor.this.attributes[r].getConstraint() instanceof XAttributeConstraintAList) {
                v = WizardKeys.getVisualListValue((XAttribute)XModelObjectEditor.this.attributes[r], (String)v);
            }
            return v;
        }

        public Object getDataAt(int r) {
            return new XAttributeInfo(XModelObjectEditor.this.object, XModelObjectEditor.this.attributes[r].getName());
        }

        public Color getColor(int r) {
            XAttributeInfo data = (XAttributeInfo)this.getDataAt(r);
            return data.isEditable() && !XModelObjectEditor.this.viewMode ? DEFAULT_COLOR : DISABLED_COLOR;
        }

        public int getWidthHint(int c) {
            return c == 0 ? 10 : 20;
        }

        public void dispose() {
            XModelObjectEditor.this.object = null;
        }
    }
}

