/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.views.navigator.CollapseAllAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.OpenActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ToggleLinkingAction;
import org.eclipse.ui.views.navigator.WorkspaceActionGroup;
import org.jboss.tools.common.model.ui.action.ModelContributionManager;
import org.jboss.tools.common.model.ui.views.navigator.NRefactorActionGroup;

public class ModelNavigatorActionGroup
extends ResourceNavigatorActionGroup {
    protected AddBookmarkAction addBookmarkAction;
    protected AddTaskAction addTaskAction;
    protected PropertyDialogAction propertyDialogAction;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected OpenActionGroup openGroup;
    protected NRefactorActionGroup refactorGroup;
    protected WorkingSetFilterActionGroup workingSetGroup;
    protected WorkspaceActionGroup workspaceGroup;
    protected ModelContributionManager mcm;
    protected boolean activateModelContribution = false;

    public ModelNavigatorActionGroup(IResourceNavigator navigator) {
        super(navigator);
        this.makeSubGroups();
    }

    protected void makeActions() {
        Shell shell = this.navigator.getSite().getShell();
        if (this.activateModelContribution) {
            this.mcm = new ModelContributionManager(shell, null);
        }
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction((IShellProvider)this.navigator.getSite(), (ISelectionProvider)this.navigator.getViewer());
        this.collapseAllAction = new CollapseAllAction(this.navigator, "Collapse All");
        this.collapseAllAction.setToolTipText("Collapse All");
        this.collapseAllAction.setImageDescriptor(this.getImageDescriptor("elcl16/collapseall.gif"));
        this.toggleLinkingAction = new ToggleLinkingAction(this.navigator, "Link with Editor");
        this.toggleLinkingAction.setToolTipText("Link with Editor");
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
    }

    protected void makeSubGroups() {
        this.openGroup = new OpenActionGroup(this.navigator);
        this.refactorGroup = new NRefactorActionGroup(this.navigator);
        this.workspaceGroup = new WorkspaceActionGroup(this.navigator);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.openGroup.setContext(context);
        this.refactorGroup.setContext(context);
        this.workspaceGroup.setContext(context);
        if (this.mcm != null) {
            this.mcm.setContext(context);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        this.openGroup.fillActionBars(actionBars);
        this.refactorGroup.fillActionBars(actionBars);
        this.workspaceGroup.fillActionBars(actionBars);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.toggleLinkingAction);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.propertyDialogAction.setEnabled(selection.size() == 1);
        this.addBookmarkAction.selectionChanged(selection);
        this.addTaskAction.selectionChanged(selection);
        this.openGroup.updateActionBars();
        this.refactorGroup.updateActionBars();
        this.workspaceGroup.updateActionBars();
        if (this.mcm != null) {
            this.mcm.markDirty();
        }
        if (this.mcm != null) {
            this.mcm.update(true);
        }
    }

    public void runDefaultAction(IStructuredSelection selection) {
        this.openGroup.runDefaultAction(selection);
    }

    public void handleKeyPressed(KeyEvent event) {
        this.refactorGroup.handleKeyPressed(event);
        this.workspaceGroup.handleKeyPressed(event);
    }

    public void dispose() {
        this.openGroup.dispose();
        this.refactorGroup.dispose();
        this.workspaceGroup.dispose();
        if (this.mcm != null) {
            this.mcm.dispose();
        }
        super.dispose();
    }
}

