/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.ui.widgets.TextAndReferenceComponent;

class Token {
    String text = "";
    boolean isReference = false;
    boolean isBreak = false;
    Rectangle r = new Rectangle(0, 0, 0, 0);
    Font font;

    Token() {
    }

    public int paint(GC g, int y, int x) {
        if (this.isBreak) {
            return x;
        }
        g.setFont(this.font);
        this.r.x = x - 2;
        this.r.y = y;
        int color = this.isReference ? 9 : 2;
        g.setForeground(Display.getDefault().getSystemColor(color));
        g.drawString(this.text, x, y);
        int w = TextAndReferenceComponent.getStringWidth(g, g.getFont(), this.text);
        int x1 = x;
        int x2 = x1 + w + 2;
        int y1 = y + g.getFont().getFontData()[0].getHeight() + 4;
        if (this.isReference) {
            g.drawLine(x1 - 2, y1, x2, y1);
        }
        this.r.x = x1;
        this.r.y = y;
        this.r.width = x2 - x1 + 2;
        this.r.height = y1 - y;
        return x1 + w;
    }

    public boolean contains(int x, int y) {
        return x >= this.r.x && x <= this.r.x + this.r.width && y >= this.r.y && y < this.r.y + this.r.height;
    }

    public static Token createBreakToken() {
        Token t = new Token();
        t.isBreak = true;
        return t;
    }

    public static Token createToken(String text, boolean reference, Font font) {
        Token t = new Token();
        t.text = text;
        t.isReference = reference;
        t.font = font;
        return t;
    }
}

