/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.other.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IPreferenceManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkspacePreferenceManager
extends AbstractPreferenceInitializer
implements IPreferenceManager {
    public static final String AUTOMATIC_BUILDER_ENABLED = "org.jboss.ide.eclipse.archives.core.automaticBuilderEnabled";
    public static final String PROJECT_SPECIFIC_PREFS = "org.jboss.ide.eclipse.archives.core.projectSpecificPreferencesEnabled";
    private static IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public static IResource getResource(IPath path) {
        IProject[] projects;
        if (path != null && (projects = workspaceRoot.getProjects()) != null) {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].getLocation().equals((Object)path)) {
                    return projects[i];
                }
                ++i;
            }
        }
        return null;
    }

    public boolean shouldBuild(IPath path) {
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            return false;
        }
        return this.isArchivesBuilderEnabled(path);
    }

    public boolean isArchivesBuilderEnabled(IPath path) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.core", AUTOMATIC_BUILDER_ENABLED);
        IResource res = WorkspacePreferenceManager.getResource(path);
        if (res != null && this.areProjectSpecificPrefsEnabled(res)) {
            try {
                if (res.getPersistentProperty(name) != null) {
                    return Boolean.parseBoolean(res.getPersistentProperty(name));
                }
            }
            catch (CoreException coreException) {}
        }
        return new InstanceScope().getNode("org.jboss.ide.eclipse.archives.core").getBoolean(AUTOMATIC_BUILDER_ENABLED, true);
    }

    public void setArchivesBuilderEnabled(IPath path, boolean value) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.core", AUTOMATIC_BUILDER_ENABLED);
        IResource resource = WorkspacePreferenceManager.getResource(path);
        try {
            if (resource != null && resource.getPersistentProperty(name) != null) {
                resource.setPersistentProperty(name, new Boolean(value).toString());
                return;
            }
        }
        catch (CoreException coreException) {}
        IEclipsePreferences prefs = new InstanceScope().getNode("org.jboss.ide.eclipse.archives.core");
        prefs.putBoolean(AUTOMATIC_BUILDER_ENABLED, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            ArchivesCore.getInstance().getLogger().log(4, e.getMessage(), (Throwable)e);
        }
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = new DefaultScope().getNode("org.jboss.ide.eclipse.archives.core");
        prefs.putBoolean(AUTOMATIC_BUILDER_ENABLED, true);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e1) {
            ArchivesCore.getInstance().getLogger().log(4, e1.getMessage(), (Throwable)e1);
        }
    }

    public boolean areProjectSpecificPrefsEnabled(IPath path) {
        return this.areProjectSpecificPrefsEnabled(WorkspacePreferenceManager.getResource(path));
    }

    public boolean areProjectSpecificPrefsEnabled(IResource resource) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.core", PROJECT_SPECIFIC_PREFS);
        try {
            if (resource != null && resource.getPersistentProperty(name) != null) {
                return Boolean.parseBoolean(resource.getPersistentProperty(name));
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void setProjectSpecificPrefsEnabled(IPath path, boolean value) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.core", PROJECT_SPECIFIC_PREFS);
        IResource resource = WorkspacePreferenceManager.getResource(path);
        try {
            if (resource != null) {
                resource.setPersistentProperty(name, new Boolean(value).toString());
                return;
            }
        }
        catch (CoreException coreException) {}
    }
}

