/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.hibernate.console.StringListDialog;

public class StringArrayDialogCellEditor
extends TextCellEditor {
    private Text text;
    private Button button;
    private Composite editor;
    private String[] strValues = null;
    private FocusListener buttonFocusListener;

    protected StringArrayDialogCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.text = (Text)super.createControl(this.editor);
        this.updateContents(this.strValues);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    StringArrayDialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addFocusListener(this.getButtonFocusListener());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringArrayDialogCellEditor.this.button.removeFocusListener(StringArrayDialogCellEditor.this.getButtonFocusListener());
                Object newValue = StringArrayDialogCellEditor.this.openDialogBox((Control)StringArrayDialogCellEditor.this.editor);
                StringArrayDialogCellEditor.this.button.addFocusListener(StringArrayDialogCellEditor.this.getButtonFocusListener());
                if (newValue != null) {
                    boolean newValidState = StringArrayDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        StringArrayDialogCellEditor.this.markDirty();
                        StringArrayDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        StringArrayDialogCellEditor.this.setErrorMessage(MessageFormat.format(StringArrayDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    StringArrayDialogCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    protected void focusLost() {
        if (!(!this.isActivated() || this.button == null || this.button.isDisposed() || this.button.isFocusControl() || this.text == null || this.text.isDisposed() || this.text.isFocusControl())) {
            this.fireApplyEditorValue();
            this.deactivate();
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        String[] value = (String[])this.getValue();
        StringListDialog pld = new StringListDialog(null, value);
        if (pld.open() == 0) {
            return pld.getValue();
        }
        return null;
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    StringArrayDialogCellEditor.this.focusLost();
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    public void deactivate() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected void editOccured(ModifyEvent e) {
        String text = this.text.getText();
        if (this.strValues == null || this.strValues.length == 0) {
            this.strValues = new String[]{text};
        } else {
            this.strValues[0] = text;
        }
        super.editOccured(e);
    }

    protected Object doGetValue() {
        return this.strValues;
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            this.strValues = new String[]{""};
        } else if (value.getClass().isArray()) {
            this.strValues = (String[])value;
        }
        super.doSetValue((Object)(this.strValues.length > 0 ? this.strValues[0] : ""));
    }

    protected void updateContents(String[] value) {
        if (this.text == null) {
            return;
        }
        String strVal = "";
        if (value != null && value.length > 0) {
            strVal = value[0];
        }
        this.text.setText(strVal);
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = StringArrayDialogCellEditor.this.button.computeSize(-1, -1, force);
            if (StringArrayDialogCellEditor.this.text != null) {
                StringArrayDialogCellEditor.this.text.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            StringArrayDialogCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = StringArrayDialogCellEditor.this.text.computeSize(-1, -1, force);
            Point buttonSize = StringArrayDialogCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

