/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.eclipse.swt.graphics.Image;
import org.hibernate.HibernateException;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.workbench.HibernateWorkbenchHelper;
import org.hibernate.eclipse.graph.model.ConfigurationViewAdapter;
import org.hibernate.eclipse.graph.model.PersistentClassViewAdapter;
import org.hibernate.eclipse.graph.model.PropertyAssociationViewAdapter;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.Property;
import org.hibernate.type.EntityType;

public class PropertyViewAdapter
extends Observable {
    private final Property property;
    private final ConfigurationViewAdapter configuration;
    private final PersistentClassViewAdapter clazz;
    private List<PropertyAssociationViewAdapter> sourceAssociations;
    private List<PropertyViewAdapter> targetAssociations;

    public PropertyViewAdapter(PersistentClassViewAdapter clazz, Property property) {
        this.clazz = clazz;
        this.property = property;
        this.configuration = clazz.getConfiguration();
        this.sourceAssociations = null;
        this.targetAssociations = Collections.emptyList();
    }

    public Property getProperty() {
        return this.property;
    }

    public List<PropertyAssociationViewAdapter> getSourceConnections() {
        this.checkConnections();
        return this.sourceAssociations;
    }

    private void checkConnections() {
        if (this.sourceAssociations == null) {
            this.sourceAssociations = new ArrayList<PropertyAssociationViewAdapter>();
            this.createSingleEndedEnityAssociations();
        }
    }

    public List<PropertyViewAdapter> getTargetConnections() {
        return this.targetAssociations;
    }

    private void createSingleEndedEnityAssociations() {
        try {
            if (this.property.getValue() instanceof Collection) {
                Collection collection = (Collection)this.property.getValue();
                if (!collection.isInverse() && collection.getElement() instanceof OneToMany) {
                    OneToMany oneToMany = (OneToMany)collection.getElement();
                    String entityName = oneToMany.getAssociatedClass().getEntityName();
                    PersistentClassViewAdapter target = this.configuration.getPersistentClassViewAdapter(entityName);
                    PropertyAssociationViewAdapter pava = new PropertyAssociationViewAdapter(this.clazz, this, target);
                    this.addSourceAssociation(pava);
                    target.addTargetAssociation(pava);
                }
            } else if (this.property.getType().isEntityType()) {
                EntityType et = (EntityType)this.property.getType();
                PersistentClassViewAdapter target = this.configuration.getPersistentClassViewAdapter(et.getAssociatedEntityName());
                PropertyAssociationViewAdapter pava = new PropertyAssociationViewAdapter(this.clazz, this, target);
                this.addSourceAssociation(pava);
                target.addTargetAssociation(pava);
            }
        }
        catch (HibernateException he) {
            HibernateConsolePlugin.getDefault().logWarning(he);
        }
    }

    private void addSourceAssociation(PropertyAssociationViewAdapter pava) {
        this.checkConnections();
        this.sourceAssociations.add(pava);
        this.setChanged();
        this.notifyObservers("ASSOCIATIONS");
    }

    public Image getImage() {
        return HibernateWorkbenchHelper.getImage(this.getProperty());
    }
}

