/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers.refactoring;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.handlers.page.RenamePageHandler;
import org.jboss.tools.struts.model.handlers.refactoring.StrutsRenamePathDiagramChange;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

public class StrutsRenameFolderStrutsConfigChange
extends CompositeChange {
    XModelObject object;
    String newName;
    XModelObject[] fs;
    String oldPath;
    String newPath;
    Properties replacements = new Properties();

    public StrutsRenameFolderStrutsConfigChange(XModelObject object, String newName) {
        super(StrutsUIMessages.STRUTS_CONFIG_CHANGES);
        this.object = object;
        this.newName = newName;
        this.replacements.clear();
        this.oldPath = object.getAttributeValue("name");
        this.newPath = newName;
        this.oldPath = "/" + this.oldPath + "/";
        this.newPath = "/" + this.newPath + "/";
        XModelObject parent = object.getParent();
        while (parent != null && parent.getFileType() == 2) {
            this.oldPath = "/" + parent.getAttributeValue("name") + this.oldPath;
            this.newPath = "/" + parent.getAttributeValue("name") + this.newPath;
            parent = parent.getParent();
        }
        this.replacements.setProperty("\"" + this.oldPath, "\"" + this.newPath);
        try {
            this.addChanges();
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void addChanges() throws Exception {
        if (this.object == null) {
            return;
        }
        this.fs = WebModulesHelper.getInstance(this.object.getModel()).getAllConfigs();
        this.addChanges(this.fs);
    }

    private void addChanges(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            XModelObject process;
            int c = this.getChildren().length;
            RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)this.replacements, (CompositeChange)this);
            if (c == this.getChildren().length && (process = StrutsProcessStructureHelper.instance.getProcess(objects[i])) != null && StrutsRenameFolderStrutsConfigChange.findPages(process, this.oldPath).length > 0) {
                this.add((Change)new StrutsRenamePathDiagramChange(objects[i], StrutsRenameFolderStrutsConfigChange.findPages(process, this.oldPath)));
            }
            ++i;
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.fs == null) {
            return null;
        }
        int i = 0;
        while (i < this.fs.length) {
            try {
                StrutsRenameFolderStrutsConfigChange.onFolderRename(this.fs[i], this.oldPath, this.newPath);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.struts", 0, e.getMessage(), (Throwable)e));
            }
            ++i;
        }
        i = 0;
        while (i < this.fs.length) {
            if (this.fs[i].isModified()) {
                XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)this.fs[i], null);
            }
            ++i;
        }
        return null;
    }

    static void onFolderRename(XModelObject config, String oldpath, String path) throws Exception {
        XModelObject process = StrutsProcessStructureHelper.instance.getProcess(config);
        if (process == null) {
            return;
        }
        XModelObject[] pages = StrutsRenameFolderStrutsConfigChange.findPages(process, oldpath);
        int i = 0;
        while (i < pages.length) {
            String op = pages[i].getAttributeValue("path");
            String np = String.valueOf(path) + op.substring(oldpath.length());
            StrutsProcessHelper.getHelper(pages[i].getParent()).resetPage(pages[i], op, np);
            pages[i].getModel().changeObjectAttribute(pages[i], "path", np);
            RenamePageHandler.changeMatchingAttributesInHierarhy(config, op, np);
            ++i;
        }
    }

    static XModelObject[] findPages(XModelObject process, String oldpath) {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject[] items = process.getChildren();
        int i = 0;
        while (i < items.length) {
            String p;
            if (!"forward".equals(items[i].getAttributeValue("type")) && (p = items[i].getAttributeValue("path")) != null && p.startsWith(oldpath)) {
                list.add(items[i]);
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }
}

