/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers.sync;

import java.util.Arrays;
import java.util.Comparator;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.jst.web.project.WebModuleConstants;

public class SortFileSystems
implements SpecialWizard,
WebModuleConstants {
    static int WEB_INF_WEIGHT = 8192;
    static int CONFIG_WEIGHT = 4096;
    static int WEB_ROOT_WEIGHT = 2048;
    static int MODULE_ROOT_WEIGHT = 1024;
    static int SRC_WEIGHT = 512;
    static int CLASSES_WEIGHT = 256;
    static int FOLDER_WEIGHT = 128;
    protected XModel model;
    XModelObject[] fs;
    int[] weight;

    public static void sort(XModel model) {
        SortFileSystems sorter = new SortFileSystems();
        sorter.setModel(model);
        sorter.sort();
    }

    public void setObject(Object object) {
        this.setModel((XModel)object);
    }

    public int execute() {
        this.sort();
        return 0;
    }

    public void setModel(XModel model) {
        this.model = model;
    }

    public void sort() {
        if (this.model.getByPath("FileSystems") == null) {
            return;
        }
        this.fs = this.model.getByPath("FileSystems").getChildren();
        this.weight = new int[this.fs.length];
        int i = 0;
        while (i < this.fs.length) {
            this.weight[i] = 50 - i;
            if ("FileSystemFolder".equals(this.fs[i].getModelEntity().getName())) {
                int n = i;
                this.weight[n] = this.weight[n] + FOLDER_WEIGHT;
                String n2 = this.fs[i].getAttributeValue("name");
                if (n2.toLowerCase().indexOf("class") >= 0) {
                    int n3 = i;
                    this.weight[n3] = this.weight[n3] + CLASSES_WEIGHT;
                }
            }
            ++i;
        }
        XModelObject[] ws = this.model.getByPath("Web").getChildren("JstWebModule");
        int i2 = 0;
        while (i2 < ws.length) {
            String src;
            String cgpath;
            String nm = ws[i2].getAttributeValue("name");
            boolean isDefault = nm.length() == 0;
            String root = ws[i2].getAttributeValue("root file system");
            int q = this.getFileSystemIndex(root);
            if (q >= 0) {
                if (isDefault) {
                    int n = q;
                    this.weight[n] = this.weight[n] | WEB_ROOT_WEIGHT;
                } else {
                    int n = q;
                    this.weight[n] = this.weight[n] | MODULE_ROOT_WEIGHT;
                }
            }
            if ((q = this.getConfigFileSystemIndex(cgpath = ws[i2].getAttributeValue("model path"))) >= 0) {
                if (isDefault) {
                    int n = q;
                    this.weight[n] = this.weight[n] | WEB_INF_WEIGHT;
                } else {
                    int n = q;
                    this.weight[n] = this.weight[n] | CONFIG_WEIGHT;
                }
            }
            if ((q = this.getFileSystemIndex(src = ws[i2].getAttributeValue("src file system"))) >= 0) {
                int n = q;
                this.weight[n] = this.weight[n] | SRC_WEIGHT;
            }
            ++i2;
        }
        if (this.isUpToDate()) {
            return;
        }
        FileSystemsImpl fsi = (FileSystemsImpl)this.model.getByPath("FileSystems");
        if (fsi != null) {
            fsi.sort((Comparator)new ComparatorImpl());
        }
    }

    private boolean isUpToDate() {
        XModelObject[] fs2 = (XModelObject[])this.fs.clone();
        ComparatorImpl c = new ComparatorImpl();
        Arrays.sort(fs2, c);
        int i = 0;
        while (i < fs2.length) {
            if (fs2[i] != this.fs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getFileSystemIndex(String name) {
        int i = 0;
        while (i < this.fs.length) {
            if (this.fs[i].getAttributeValue("name").equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getFileSystemIndex(XModelObject s) {
        int i = 0;
        while (i < this.fs.length) {
            if (this.fs[i] == s) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getConfigFileSystemIndex(String path) {
        XModelObject o = this.model.getByPath(path);
        while (o != null && o.getFileType() != 3) {
            o = o.getParent();
        }
        return o == null ? -1 : this.getFileSystemIndex(o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComparatorImpl
    implements Comparator<XModelObject> {
        ComparatorImpl() {
        }

        @Override
        public int compare(XModelObject o1, XModelObject o2) {
            int i1 = SortFileSystems.this.getFileSystemIndex(o1);
            int i2 = SortFileSystems.this.getFileSystemIndex(o2);
            if (i1 < 0 || i2 < 0) {
                return 0;
            }
            return SortFileSystems.this.weight[i2] - SortFileSystems.this.weight[i1];
        }
    }
}

