/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.resource.ConfigInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMapping {
    WebModulesHelper wh = null;
    Map<String, ConfigInfo> infos = new HashMap<String, ConfigInfo>();

    public ResourceMapping(WebModulesHelper wh) {
        this.wh = wh;
    }

    public void revalidate() {
        Set<String> modules = this.wh.getModules();
        if (this.isUpToDate(modules)) {
            return;
        }
        this.createInfos(modules);
    }

    private boolean isUpToDate(Set<String> modules) {
        if (modules.size() != this.infos.size()) {
            return false;
        }
        boolean result = true;
        for (String key : modules) {
            ConfigInfo i = this.infos.get(key);
            if (i == null) {
                result = false;
                continue;
            }
            if (i.isUpToDate()) continue;
            result = false;
            this.infos.remove(key);
        }
        return result;
    }

    private boolean createInfos(Set<String> modules) {
        boolean result = false;
        String[] ms = modules.toArray(new String[0]);
        int i = 0;
        while (i < ms.length) {
            XModelObject cg;
            ConfigInfo ci = this.infos.get(ms[i]);
            if (!(ci != null && ci.isUpToDate() || (cg = this.wh.getConfigForModule(this.wh.getModel(), ms[i])) == null)) {
                ci = new ConfigInfo(cg);
                this.infos.put(ms[i], ci);
                result = true;
            }
            ++i;
        }
        return result;
    }

    public Set<String> getResources(XModelObject o) {
        while (o != null && o.getFileType() != 1) {
            o = o.getParent();
        }
        HashSet<String> result = new HashSet<String>();
        if (o == null) {
            return result;
        }
        String path = o.getPath();
        ConfigInfo[] cs = this.infos.values().toArray(new ConfigInfo[0]);
        int i = 0;
        while (i < cs.length) {
            if (cs[i].validators.data.contains(path)) {
                result.addAll(cs[i].resources.data);
            }
            ++i;
        }
        return result;
    }
}

