/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.model.LibraryMacroDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.util.StringUtil;
import org.w3c.dom.Element;

public class MacroLibrary {
    public static final String TYPE_FILE = "file";
    public static final String TYPE_JAR_ENTRY = "jarEntry";
    private long lastUpdatedTime;
    private IFile file;
    private String content;
    private String path;
    private String namespace;
    private String type;
    private MacroDirective[] macros;

    public MacroLibrary(String namespace, IFile file) throws IOException, CoreException {
        this.namespace = namespace;
        this.file = file;
        this.content = StringUtil.getStringFromStream(file.getContents(true));
        this.type = TYPE_FILE;
    }

    public MacroLibrary(String namespace, InputStream is, String path, String type) throws IOException {
        this.namespace = namespace;
        this.content = StringUtil.getStringFromStream(is);
        this.type = type;
        this.path = path;
        if (this.type == null) {
            this.type = TYPE_FILE;
        }
    }

    public synchronized MacroDirective[] getMacros() {
        if (this.macros == null || this.isStale()) {
            this.load();
        }
        return this.macros;
    }

    public boolean isStale() {
        return this.file != null && this.file.getModificationStamp() > this.lastUpdatedTime;
    }

    public IFile getFile() {
        return this.file;
    }

    private void load() {
        try {
            int index;
            ArrayList<LibraryMacroDirective> macros = new ArrayList<LibraryMacroDirective>();
            String search = "#macro ";
            int startIndex = index = this.content.indexOf(search);
            char startChar = this.content.charAt(index - 1);
            char endChar = startChar == '[' ? (char)']' : '>';
            while (startIndex > 0) {
                int stackCount = 0;
                boolean inString = false;
                int endIndex = Integer.MIN_VALUE;
                boolean escape = false;
                while (this.content.length() > index && index >= 0) {
                    boolean doEscape = false;
                    char c = this.content.charAt(index++);
                    if (!escape) {
                        if (c == '\"') {
                            inString = !inString;
                        } else if (c == '\\' && inString) {
                            doEscape = true;
                        } else if (c == startChar) {
                            ++stackCount;
                        } else if (c == endChar) {
                            if (stackCount > 0) {
                                --stackCount;
                            } else {
                                endIndex = index - 1;
                                break;
                            }
                        }
                    }
                    escape = doEscape;
                }
                if (endIndex <= 0) break;
                String sub = this.content.substring(startIndex, endIndex);
                LibraryMacroDirective macroDirective = new LibraryMacroDirective(this.namespace, sub, startIndex - 1, endIndex - index + 2);
                macros.add(macroDirective);
                index = this.content.indexOf(String.valueOf(startChar) + search, endIndex);
                if (index >= 0) {
                    // empty if block
                }
                startIndex = ++index;
                endIndex = Integer.MIN_VALUE;
            }
            this.macros = macros.toArray(new MacroDirective[macros.size()]);
            if (this.file != null) {
                this.lastUpdatedTime = this.file.getModificationStamp();
            }
        }
        catch (Exception e) {
            this.macros = new MacroDirective[0];
            Plugin.log(e);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<entry namespace=\"" + this.getNamespace() + "\" ");
        sb.append("path=\"" + this.getPath() + "\" ");
        if (this.file != null) {
            sb.append("project=\"" + this.file.getProject().getName() + "\" ");
        }
        sb.append("type=\"" + this.getType() + "\"/>");
        return sb.toString();
    }

    public String getPath() {
        if (this.file != null) {
            return this.file.getProjectRelativePath().toString();
        }
        return this.path;
    }

    public static MacroLibrary fromXML(IProject project, Element node, ClassLoader classLoader) throws CoreException, IOException {
        String namespace = node.getAttribute("namespace");
        String path = node.getAttribute("path");
        String projectName = node.getAttribute("project");
        String type = node.getAttribute("type");
        if (type == null || type.length() == 0 || type.equals(TYPE_FILE)) {
            IFile file;
            if (projectName != null && projectName.length() > 0) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if ((file = project.getFile((IPath)new Path(path))) == null || !file.exists()) {
                return null;
            }
            return new MacroLibrary(namespace, file);
        }
        if (type.equals(TYPE_JAR_ENTRY)) {
            InputStream is = classLoader.getResourceAsStream(path);
            if (is != null) {
                return new MacroLibrary(namespace, is, path, TYPE_JAR_ENTRY);
            }
            return null;
        }
        return null;
    }
}

