/*******************************************************************************
 * Copyright (c) 2007-2011 Exadel, Inc. and Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Exadel, Inc. and Red Hat, Inc. - initial API and implementation
 ******************************************************************************/
package org.jboss.tools.vpe.html.template;

import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.HTML;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HtmlTemplate extends VpeAbstractTemplate {
	
	@Override
	public VpeCreationData create(VpePageContext pageContext, Node sourceNode,
			nsIDOMDocument visualDocument) {		
		Element  sourceElement = (Element) sourceNode;
		/*
		 * Set "xmlns" attribute to the generated by VPE html stub.
		 */
		nsIDOMNode htmlNode = visualDocument.getElementsByTagName(HTML.TAG_HTML).item(0);
		nsIDOMElement htmlElement = (nsIDOMElement)htmlNode.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
		NamedNodeMap namedNodes = sourceElement.getAttributes();
		for(int i=0;i<namedNodes.getLength();i++){
			Attr sourceAttr = (Attr) namedNodes.item(i);
			htmlElement.setAttribute(sourceAttr.getName(),sourceAttr.getValue());
		}
		return new VpeCreationData(visualDocument.createElement(HTML.TAG_DIV));
	}
}
