/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.extractor;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.hibernate.eclipse.hqleditor.CompletionHelper;
import org.hibernate.eclipse.hqleditor.HibernateResultCollector;
import org.hibernate.eclipse.mapper.extractor.HBMInfoExtractor;
import org.hibernate.eclipse.mapper.extractor.HBMInfoHandler;
import org.hibernate.util.xpl.StringHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class JavaTypeHandler
implements HBMInfoHandler {
    protected final HBMInfoExtractor extractor;

    public JavaTypeHandler(HBMInfoExtractor extractor) {
        this.extractor = extractor;
    }

    public ICompletionProposal[] attributeCompletionProposals(IJavaProject project, Node node, String attributeName, String start, int offset) {
        HibernateResultCollector.Settings settings = new HibernateResultCollector.Settings();
        settings.setAcceptClasses(true);
        settings.setAcceptInterfaces(true);
        settings.setAcceptPackages(true);
        settings.setAcceptTypes(true);
        String packageName = this.extractor.getPackageName(node);
        if (StringHelper.isEmpty((String)start) && StringHelper.isNotEmpty((String)packageName)) {
            start = String.valueOf(packageName) + ".";
        }
        return CompletionHelper.completeOnJavaTypes((IJavaProject)project, (HibernateResultCollector.Settings)settings, (String)packageName, (String)start, (int)offset);
    }

    public IJavaElement getJavaElement(IJavaProject project, Node currentNode, Attr currentAttrNode) {
        return this.getNearestTypeJavaElement(project, currentNode);
    }

    public IJavaElement getNearestTypeJavaElement(IJavaProject project, Node currentNode) {
        String nearestType = this.extractor.getNearestType(project, currentNode);
        if (nearestType != null) {
            try {
                IType type = project.findType(nearestType);
                return type;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }
}

