/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.EditorPartFactory;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapperExtension;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;

public class XMLEditorLauncher
implements IEditorLauncher {
    static String DEFAULT_ENTITY = "xml";

    public void open(IFile file) {
        FileEditorInput f = new FileEditorInput(file);
        IEditorInput input = XModelObjectEditorInput.checkInput((IEditorInput)f);
        String entity = this.computeEntity(input);
        EditorPartWrapperExtension extension = EditorPartWrapperExtension.getInstance();
        EditorPartFactory factory = extension.getFactory(entity);
        String id = factory.getEditorId();
        if (id == null) {
            id = "org.jboss.tools.common.text.xml.internal.ui.xmleditor.XmlEditor";
        }
        new Thread(new LaunchThread(id, input)).start();
    }

    private String computeEntity(IEditorInput input) {
        if (!(input instanceof IModelObjectEditorInput)) {
            return DEFAULT_ENTITY;
        }
        IModelObjectEditorInput i = (IModelObjectEditorInput)input;
        XModelObject o = i.getXModelObject();
        if (o == null) {
            return DEFAULT_ENTITY;
        }
        EditorPartWrapperExtension extension = EditorPartWrapperExtension.getInstance();
        EditorPartFactory f = extension.getFactory(o.getModelEntity().getName());
        if (f == null) {
            return DEFAULT_ENTITY;
        }
        return o.getModelEntity().getName();
    }

    public static IFile convert(IPath path) {
        String location = path.toFile().getAbsolutePath();
        IProject[] projects = ModelUIPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (projects != null && i < projects.length) {
            if (projects[i].isOpen()) {
                IFile f = XMLEditorLauncher.find((IResource)projects[i], location);
                if (f != null) {
                    return f;
                }
                IResource[] rs = null;
                try {
                    rs = projects[i].members(true);
                }
                catch (CoreException coreException) {}
                if (rs != null) {
                    int j = 0;
                    while (j < rs.length) {
                        if (rs[j].isLinked() && (f = XMLEditorLauncher.find(rs[j], location)) != null) {
                            return f;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return ModelUIPlugin.getWorkspace().getRoot().getFile(path);
    }

    public void open(IPath path) {
        this.open(XMLEditorLauncher.convert(path));
    }

    private static IFile find(IResource resource, String location) {
        String l = resource.getLocation().toFile().getAbsolutePath();
        if (!location.startsWith(l)) {
            return null;
        }
        String relative = location.substring(l.length()).replace('\\', '/');
        StringTokenizer st = new StringTokenizer(relative, "/");
        while (st.hasMoreTokens()) {
            IContainer container;
            String token = st.nextToken();
            if (!(resource instanceof IContainer) || (resource = (container = (IContainer)resource).findMember(token)) == null) break;
            if (st.hasMoreTokens() || !(resource instanceof IFile)) continue;
            return (IFile)resource;
        }
        return null;
    }

    class LaunchThread
    implements Runnable {
        String id;
        IEditorInput input;

        LaunchThread(String id, IEditorInput input) {
            this.id = id;
            this.input = input;
        }

        public void run() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage workbenchPage = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    int time = 100;
                    while (workbenchPage.findEditor(LaunchThread.this.input) != null) {
                        if (time > 1000) {
                            return;
                        }
                        try {
                            Thread.sleep(time);
                        }
                        catch (InterruptedException interruptedException) {}
                        time *= 2;
                    }
                    try {
                        workbenchPage.openEditor(LaunchThread.this.input, LaunchThread.this.id);
                    }
                    catch (PartInitException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            });
        }
    }
}

