/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public abstract class AbstractModelActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected XModelObject object = null;
    protected IWorkbenchWindow window;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void selectionChanged(final IAction action, final ISelection selection) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AbstractModelActionDelegate.this.safeSelectionChanged(action, selection);
            }
        });
    }

    protected void safeSelectionChanged(IAction action, ISelection selection) {
        XModelObject adapter;
        if (this.object == null && action.isEnabled()) {
            action.setEnabled(false);
        }
        if ((adapter = this.getAdapter(selection)) == null) {
            return;
        }
        this.object = adapter;
        action.setEnabled(this.computeEnabled());
    }

    protected final XModelObject getAdapter(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        if (o instanceof IResource) {
            return EclipseResourceUtil.getObjectByResource((IResource)((IResource)o));
        }
        if (o instanceof IJavaElement) {
            return EclipseResourceUtil.getObjectByResource((IResource)((IJavaElement)o).getJavaProject().getProject());
        }
        return o instanceof XModelObject ? (XModelObject)o : null;
    }

    protected abstract boolean computeEnabled();

    public void run(IAction action) {
        try {
            this.doRun();
        }
        catch (XModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected abstract void doRun() throws XModelException;

    public void dispose() {
    }
}

